/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.sdk.storage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openapitools.sdk.enums.StorageEnums;
import org.openapitools.sdk.storage.BaseStorage;
import org.openapitools.sdk.utils.Utils;

public class Storage
extends BaseStorage {
    private static Storage instance;
    private static Long tokenTimeToLive;
    private static final Map<String, String> storageMap;

    public static Storage getInstance() {
        if (instance == null) {
            instance = new Storage();
        }
        return instance;
    }

    public static Map<String, Object> getToken(HttpServletRequest request) {
        try {
            String token = Storage.getItem(request, StorageEnums.TOKEN.getValue());
            if (token.equals("")) {
                return null;
            }
            String decodedToken = URLDecoder.decode(token, "UTF-8");
            return (Map)new ObjectMapper().readValue(decodedToken, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setToken(HttpServletResponse response, Object token) {
        String tok = "";
        if (token instanceof String) {
            tok = (String)token;
        } else if (token instanceof Map) {
            try {
                tok = URLEncoder.encode(new ObjectMapper().writeValueAsString((Object)((Map)token)), "UTF-8");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid output");
            }
        }
        Storage.setItem(response, StorageEnums.TOKEN.getValue(), tok, Storage.getTokenTimeToLive().intValue());
    }

    public static String getAccessToken(HttpServletRequest request) {
        Map<String, Object> token = Storage.getToken(request);
        return token != null ? (String)token.get("access_token") : null;
    }

    public static String getIdToken(HttpServletRequest request) {
        Map<String, Object> token = Storage.getToken(request);
        return token != null ? (String)token.get("id_token") : null;
    }

    public static String getRefreshToken(HttpServletRequest request) {
        Map<String, Object> token = Storage.getToken(request);
        return token != null ? (String)token.get("refresh_token") : null;
    }

    public static Long getExpiredAt(HttpServletRequest request) {
        String accessToken = Storage.getAccessToken(request);
        return accessToken != null ? ((Integer)Utils.parseJWT(accessToken).get("exp")).longValue() : 0L;
    }

    public static Long getTokenTimeToLive() {
        return tokenTimeToLive != null ? tokenTimeToLive : System.currentTimeMillis() + 1296000000L;
    }

    public static void setTokenTimeToLive(Long tokenTTL) {
        tokenTimeToLive = tokenTTL;
    }

    public static String getState(HttpServletRequest request) {
        return Storage.getItem(request, StorageEnums.STATE.getValue());
    }

    public static void setState(HttpServletResponse response, String newState) {
        Storage.setItem(response, StorageEnums.STATE.getValue(), newState, (int)(System.currentTimeMillis() + 7200L));
    }

    public static String getCodeVerifier(HttpServletRequest request) {
        return Storage.getItem(request, StorageEnums.CODE_VERIFIER.getValue());
    }

    public static void setCodeVerifier(HttpServletResponse response, String newCodeVerifier) {
        Storage.setItem(response, StorageEnums.CODE_VERIFIER.getValue(), newCodeVerifier, (int)(System.currentTimeMillis() + 7200L));
    }

    public static Map<String, Object> getUserProfile(HttpServletRequest request) {
        Map<String, Object> token = Storage.getToken(request);
        String idToken = Storage.getIdToken(request);
        Map<String, Object> payload = Utils.parseJWT(idToken);
        ConcurrentHashMap<String, Object> userProfile = new ConcurrentHashMap<String, Object>();
        userProfile.put("id", payload.containsKey("sub") && payload.get("sub") != null ? payload.get("sub") : "");
        userProfile.put("given_name", payload.containsKey("given_name") && payload.get("given_name") != null ? payload.get("given_name") : "");
        userProfile.put("family_name", payload.containsKey("family_name") && payload.get("family_name") != null ? payload.get("family_name") : "");
        userProfile.put("email", payload.containsKey("email") && payload.get("email") != null ? payload.get("email") : "");
        userProfile.put("picture", payload.containsKey("picture") && payload.get("picture") != null ? payload.get("picture") : "");
        return userProfile;
    }

    static {
        storageMap = new ConcurrentHashMap<String, String>();
    }
}

