/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.sdk.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.sdk.enums.AdditionalParameters;

public class Utils {
    public static Map<String, String> listType = new HashMap<String, String>();

    public static String base64UrlEncode(String str) {
        String base64 = Base64.getEncoder().encodeToString(str.getBytes());
        base64 = base64.replaceAll("=", "");
        base64 = base64.replaceAll("\\+", "");
        String base64url = base64 = base64.replaceAll("/", "");
        return base64url;
    }

    public static String sha256(String str) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(str.getBytes());
            return Utils.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    public static String randomString(int length) {
        byte[] randomBytes = new byte[length];
        new SecureRandom().nextBytes(randomBytes);
        return Utils.base64UrlEncode(new String(randomBytes));
    }

    public static String randomString() {
        return Utils.randomString(32);
    }

    public static Map<String, String> generateChallenge() {
        String state = Utils.randomString();
        String codeVerifier = Utils.generateRandomCodeVerifier();
        String codeChallenge = Utils.generateCodeChallenge(codeVerifier);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("state", state);
        result.put("codeVerifier", codeVerifier);
        result.put("codeChallenge", codeChallenge);
        return result;
    }

    public static String generateRandomCodeVerifier() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] randomBytes = new byte[32];
        secureRandom.nextBytes(randomBytes);
        String codeVerifier = Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
        return codeVerifier;
    }

    public static String generateCodeChallenge(String codeVerifier) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] codeVerifierBytes = codeVerifier.getBytes();
            digest.update(codeVerifierBytes);
            byte[] digestBytes = digest.digest();
            String codeChallenge = Base64.getUrlEncoder().withoutPadding().encodeToString(digestBytes);
            return codeChallenge;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    public static boolean validateURL(String url) {
        String pattern = "https?://(?:w{1,3}\\.)?[^\\s.]+(?:\\.[a-z]+)*(?::\\d+)?(?![^<]*(?:<\\/?\\w+>|\\/?>))";
        return url.matches(pattern);
    }

    public static Map<String, Object> parseJWT(String token) {
        try {
            String[] tokenParts = token.split("\\.");
            String encodedPayload = tokenParts[1];
            encodedPayload = encodedPayload.replace('_', '/').replace('-', '+');
            byte[] decodedBytes = Base64.getDecoder().decode(encodedPayload);
            String decodedPayload = new String(decodedBytes);
            return (Map)new ObjectMapper().readValue(decodedPayload, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Object> checkAdditionalParameters(Map<String, Object> additionalParameters) {
        if (additionalParameters == null || additionalParameters.isEmpty()) {
            return new HashMap<String, Object>();
        }
        Map<String, String> additionalParametersValid = AdditionalParameters.ADDITIONAL_PARAMETER;
        String[] keysAvailable = additionalParametersValid.keySet().toArray(new String[0]);
        for (String key : additionalParameters.keySet()) {
            if (!Arrays.asList(keysAvailable).contains(key)) {
                throw new IllegalArgumentException("Please provide correct additional, " + key);
            }
            if (additionalParameters.get(key).getClass().getSimpleName().equalsIgnoreCase(additionalParametersValid.get(key))) continue;
            throw new IllegalArgumentException("Please supply a valid " + key + ". Expected: " + additionalParametersValid.get(key));
        }
        return additionalParameters;
    }

    public static Map<String, Object> addAdditionalParameters(Map<String, Object> target, Map<String, Object> additionalParameters) {
        Map<String, Object> newAdditionalParameters = Utils.checkAdditionalParameters(additionalParameters);
        HashMap<String, Object> mutableTarget = new HashMap<String, Object>(target);
        if (newAdditionalParameters != null && !newAdditionalParameters.isEmpty()) {
            mutableTarget.putAll(newAdditionalParameters);
        }
        return mutableTarget;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    static {
        listType.put("s", "string");
        listType.put("i", "integer");
        listType.put("b", "boolean");
    }
}

