/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.processor;

import com.ksptooi.guice.annotations.Unit;
import com.ksptooi.psm.processor.ServiceUnitManager;
import com.ksptooi.psm.processor.ShellRequest;
import com.ksptooi.psm.processor.SrvUnitTools;
import com.ksptooi.psm.processor.entity.ActivatedSrvUnit;
import com.ksptooi.psm.processor.entity.Process;
import com.ksptooi.psm.processor.entity.SrvDefine;
import com.ksptooi.psm.processor.event.generic.ServiceUnitEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unit
public class EventSchedule {
    private static final Logger log = LoggerFactory.getLogger(EventSchedule.class);
    private static final Map<String, List<SrvDefine>> eventMap = new ConcurrentHashMap<String, List<SrvDefine>>();

    public void register(SrvDefine def) {
        if (def == null) {
            log.error("\u65e0\u6cd5\u6ce8\u518c\u4e8b\u4ef6\u5904\u7406\u5668,\u5185\u90e8\u9519\u8bef(E1)");
            return;
        }
        if (!def.getDefType().equals("event_handler")) {
            log.error("\u65e0\u6cd5\u6ce8\u518c\u4e8b\u4ef6\u5904\u7406\u5668,Define\u7c7b\u578b\u9519\u8bef. \u4f4d\u4e8eProc:{}.{}", (Object)def.getSrvUnitName(), (Object)def.getMethod().getName());
            return;
        }
        List emList = eventMap.computeIfAbsent(def.getEventHandlerType(), k -> new ArrayList());
        emList.add(def);
        Collections.sort(emList);
        log.info("\u6ce8\u518c\u4e8b\u4ef6\u5904\u7406\u5668 {}:{}({})..{}", new Object[]{def.getSrvUnitName(), def.getEventName(), def.getEventHandlerOrder(), def.getMethod().getName()});
    }

    public ServiceUnitEvent forward(ServiceUnitEvent event) {
        String eventType = event.getClass().getName();
        this.trigger(event, event.getUserShell().getCurrentProcess());
        if (!eventMap.containsKey(eventType)) {
            return event;
        }
        List<SrvDefine> defines = eventMap.get(eventType);
        for (SrvDefine def : defines) {
            try {
                ActivatedSrvUnit processor = ServiceUnitManager.getProcessor(def.getSrvUnitName());
                def.getMethod().invoke(processor.getSrvUnit(), event);
                if (!event.isIntercepted()) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warn("\u6267\u884c\u4e8b\u4ef6\u65f6\u51fa\u73b0\u9519\u8bef. \u5904\u7406\u5668:{} \u4e8b\u4ef6\u540d:{} \u4e8b\u4ef6\u5904\u7406\u5668:{}", new Object[]{def.getSrvUnitName(), def.getEventName(), def.getMethod().getName()});
            }
        }
        return event;
    }

    private ServiceUnitEvent trigger(ServiceUnitEvent event, Process task) {
        if (task == null) {
            return event;
        }
        if (!task.getInstance().isAlive() || task.getStage() != Process.STAGE_RUNNING.intValue()) {
            return event;
        }
        Object processInstance = task.getServiceUnit().getSrvUnit();
        List<SrvDefine> defines = task.getServiceUnit().getSrvDefines();
        ArrayList<SrvDefine> handler = new ArrayList<SrvDefine>();
        ShellRequest request = task.getRequest();
        for (SrvDefine def : defines) {
            if (!def.getDefType().equals("event_handler") || def.isGlobalEventHandler() || !def.getEventHandlerType().equals(event.getClass().getName())) continue;
            handler.add(def);
        }
        Collections.sort(handler);
        for (SrvDefine item : handler) {
            try {
                if (item.getMethod().getParameterCount() < 1) continue;
                Object[] params = SrvUnitTools.assemblyParams(item.getMethod(), new ArrayList<String>(), event, request);
                item.getMethod().invoke(processInstance, params);
                if (!event.isIntercepted()) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warn("\u6267\u884c\u4e8b\u4ef6\u65f6\u51fa\u73b0\u9519\u8bef. \u5904\u7406\u5668:{} \u4e8b\u4ef6\u540d:{} \u4e8b\u4ef6\u5904\u7406\u5668:{}", new Object[]{item.getSrvUnitName(), item.getEventName(), item.getMethod().getName()});
            }
        }
        return event;
    }

    private ServiceUnitEvent triggerGlobal(ServiceUnitEvent event) {
        return event;
    }

    public Map<String, List<SrvDefine>> getEventMap() {
        return eventMap;
    }
}

