/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.processor;

import com.ksptooi.psm.processor.Alias;
import com.ksptooi.psm.processor.EventHandler;
import com.ksptooi.psm.processor.OnActivated;
import com.ksptooi.psm.processor.OnDestroy;
import com.ksptooi.psm.processor.RequestHandler;
import com.ksptooi.psm.processor.ServiceUnit;
import com.ksptooi.psm.processor.SrvDefineException;
import com.ksptooi.psm.processor.TestServiceUnit;
import com.ksptooi.psm.processor.entity.SrvDefine;
import com.ksptooi.psm.processor.event.BadRequestEvent;
import com.ksptooi.psm.processor.event.InstallProcHandlerEvent;
import com.ksptooi.psm.processor.event.RequestForwardEvent;
import com.ksptooi.psm.processor.event.ServiceUnitRegisterEvent;
import com.ksptooi.psm.processor.event.ShellInputEvent;
import com.ksptooi.psm.processor.event.StatementCommitEvent;
import com.ksptooi.psm.processor.event.UserTypingEvent;
import com.ksptooi.uac.commons.ReflectUtils;
import com.ksptooi.uac.core.annatatiotion.Param;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SrvUnitTools {
    public static final List<String> eventDefine = new ArrayList<String>();

    public static List<Object> getSrvUnitInstance(Set<Class<?>> classSet) {
        if (classSet.isEmpty()) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Class<?> item : classSet) {
            try {
                Object processor = item.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ret.add(processor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static List<SrvDefine> getSrvDefine(Class<?> srvUnit) throws SrvDefineException {
        SrvDefine defHook;
        ServiceUnit annoSrvUnit = srvUnit.getAnnotation(ServiceUnit.class);
        if (annoSrvUnit == null) {
            throw new SrvDefineException("\u670d\u52a1\u5355\u5143\u5df2\u635f\u574f,\u539f\u56e0:\u670d\u52a1\u5355\u5143\u9700\u8981@ServiceUnit\u6ce8\u89e3. \u4f4d\u4e8e:" + srvUnit.getName());
        }
        if (!SrvUnitTools.chkSrvUnitName(annoSrvUnit.value())) {
            throw new SrvDefineException("\u670d\u52a1\u5355\u5143\u5df2\u635f\u574f,\u539f\u56e0:\u5904\u7406\u5668\u540d\u79f0\u4e0d\u5408\u6cd5. \u4f4d\u4e8e:" + srvUnit.getName());
        }
        String procName = annoSrvUnit.value();
        Method[] annoOnActivated = ReflectUtils.getMethodByAnnotation(srvUnit, OnActivated.class);
        Method[] annoOnDestroy = ReflectUtils.getMethodByAnnotation(srvUnit, OnDestroy.class);
        if (annoOnActivated.length > 1 || annoOnDestroy.length > 1) {
            throw new SrvDefineException("\u5904\u7406\u5668\u4e0d\u652f\u6301\u540c\u65f6\u62e5\u6709\u591a\u4e2a\u76f8\u540c\u7684\u94a9\u5b50\u6ce8\u89e3 \u4f4d\u4e8e:" + procName);
        }
        Method[] annoReqHandler = ReflectUtils.getMethodByAnnotation(srvUnit, RequestHandler.class);
        ArrayList<SrvDefine> ret = new ArrayList<SrvDefine>();
        if (annoOnActivated.length > 0) {
            defHook = new SrvDefine();
            defHook.setDefType("hook_activated");
            defHook.setMethod(annoOnActivated[0]);
            ret.add(defHook);
        }
        if (annoOnDestroy.length > 0) {
            defHook = new SrvDefine();
            defHook.setDefType("hook_destroy");
            defHook.setMethod(annoOnDestroy[0]);
            ret.add(defHook);
        }
        if (!SrvUnitTools.chkReqHandlerPattern(annoReqHandler)) {
            throw new SrvDefineException("\u5904\u7406\u5668\u5df2\u635f\u574f \u539f\u56e0:\u81f3\u5c11\u6709\u4e00\u4e2a\u8bf7\u6c42\u6620\u5c04Pattern\u4e0d\u5408\u6cd5 \u4f4d\u4e8e:" + procName);
        }
        if (!SrvUnitTools.chkRepeatWildcard(annoReqHandler)) {
            throw new SrvDefineException("\u5904\u7406\u5668\u5df2\u635f\u574f \u539f\u56e0:\u5904\u7406\u5668\u4e0d\u652f\u6301\u591a\u4e2a\u6a21\u5f0f\u4e3a\u901a\u914d\u7b26(*)\u7684\u8bf7\u6c42\u6620\u5c04 \u4f4d\u4e8e:" + procName);
        }
        for (Method m : annoReqHandler) {
            String pattern = m.getAnnotation(RequestHandler.class).value();
            List<String> alias = SrvUnitTools.getAliasByAnnotation(m);
            List<String> params = SrvUnitTools.getParamNameByAnnotation(m);
            SrvDefine def = new SrvDefine();
            def.setDefType("request_handler");
            def.setPattern(pattern);
            def.setSrvUnitName(procName);
            def.setAlias(alias);
            def.setParams(params);
            def.setParamCount(params.size());
            def.setMethod(m);
            ret.add(def);
        }
        if (!SrvUnitTools.checkRepeatMapping(ret)) {
            throw new SrvDefineException("\u5904\u7406\u5668\u5df2\u635f\u574f \u539f\u56e0:\u5904\u7406\u5668\u4e2d\u6709\u4e24\u4e2a\u76f8\u540c\u7684\u6620\u5c04 \u4f4d\u4e8e:" + procName);
        }
        ret.addAll(SrvUnitTools.getEventHandlerInSrvUnit(srvUnit));
        return ret;
    }

    public static String getSrvUnitName(Class<?> proc) {
        ServiceUnit annoProc = proc.getAnnotation(ServiceUnit.class);
        if (annoProc == null) {
            return null;
        }
        return annoProc.value();
    }

    private static List<String> getAliasByAnnotation(Method m) {
        Alias annoAlias = m.getAnnotation(Alias.class);
        if (annoAlias == null || annoAlias.value().length < 1) {
            return new ArrayList<String>();
        }
        return Arrays.stream(annoAlias.value()).toList();
    }

    private static List<String> getParamNameByAnnotation(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<String> retString = new ArrayList<String>();
        Annotation[][] annotationArray = parameterAnnotations;
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] anno;
            for (Annotation item : anno = annotationArray[i]) {
                if (!(item instanceof Param)) continue;
                retString.add(((Param)item).value());
            }
        }
        return retString;
    }

    public static Object[] assemblyParams(Method m, List<String> outsideParams, Object ... innerParam) {
        return SrvUnitTools.assemblyParams(m, innerParam, outsideParams);
    }

    public static Object[] assemblyParams(Method method, Object[] innerParam, List<String> stringParam) {
        Class<?>[] parameterTypes;
        if (stringParam == null) {
            stringParam = new ArrayList<String>();
        }
        if ((parameterTypes = method.getParameterTypes()).length - innerParam.length > stringParam.size()) {
            return null;
        }
        Object[] params = new Object[method.getParameterCount()];
        int paramCount = 0;
        for (int i = 0; i < parameterTypes.length; ++i) {
            boolean isInnerParam = false;
            for (Object item : innerParam) {
                if (!parameterTypes[i].isInstance(item)) continue;
                params[i] = item;
                isInnerParam = true;
            }
            try {
                if (isInnerParam) continue;
                params[i] = stringParam.get(paramCount);
                ++paramCount;
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return params;
    }

    public static boolean chkSrvUnitName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        return !name.contains("*");
    }

    public static boolean chkReqHandlerPattern(Method[] methods) {
        for (Method m : methods) {
            String pattern;
            RequestHandler anno = m.getAnnotation(RequestHandler.class);
            if (anno == null || !StringUtils.isBlank((CharSequence)(pattern = anno.value()))) continue;
            return false;
        }
        return true;
    }

    public static boolean chkRepeatWildcard(Method[] m) {
        if (m == null || m.length < 1) {
            return true;
        }
        int count = 0;
        for (Method item : m) {
            RequestHandler anno = item.getAnnotation(RequestHandler.class);
            if (anno == null || !anno.value().equals("*")) continue;
            ++count;
        }
        return count <= 1;
    }

    public static boolean checkRepeatMapping(List<SrvDefine> defines) {
        HashSet<CallSite> hSet = new HashSet<CallSite>();
        for (SrvDefine def : defines) {
            if (!def.getDefType().equals("request_handler")) continue;
            String identity = def.getSrvUnitName() + "::" + def.getPattern() + "::" + def.getParamCount();
            if (hSet.contains(identity)) {
                return false;
            }
            hSet.add((CallSite)((Object)identity));
        }
        return true;
    }

    public static List<SrvDefine> getEventHandlerInSrvUnit(Class<?> srvUnit) throws SrvDefineException {
        String srvUnitName = srvUnit.getAnnotation(ServiceUnit.class).value();
        Method[] annoEventHandler = ReflectUtils.getMethodByAnnotation(srvUnit, EventHandler.class);
        ArrayList<SrvDefine> ret = new ArrayList<SrvDefine>();
        for (Method m : annoEventHandler) {
            String eventHandlerType = SrvUnitTools.getEventHandlerType(m);
            if (eventHandlerType == null) {
                throw new SrvDefineException("\u4e8b\u4ef6\u5904\u7406\u5668\u5df2\u635f\u574f. ProcName:" + srvUnitName + " FuncName:" + m.getName());
            }
            SrvDefine def = new SrvDefine();
            def.setDefType("event_handler");
            def.setSrvUnitName(srvUnitName);
            def.setMethod(m);
            def.setEventHandlerOrder(m.getAnnotation(EventHandler.class).order());
            def.setEventHandlerType(eventHandlerType);
            String eventHandlerEventName = SrvUnitTools.getEventHandlerEventName(m);
            def.setEventName(eventHandlerEventName);
            def.setGlobalEventHandler(m.getAnnotation(EventHandler.class).global());
            ret.add(def);
        }
        return ret;
    }

    public static String getEventHandlerType(Method m) {
        if (m.getParameterCount() < 1) {
            return null;
        }
        Class<?> firstParam = m.getParameterTypes()[0];
        String firstParamTN = firstParam.getName();
        for (String def : eventDefine) {
            if (!def.equals(firstParamTN)) continue;
            return firstParamTN;
        }
        return null;
    }

    public static String getEventHandlerEventName(Method m) {
        if (m.getParameterCount() < 1) {
            return null;
        }
        Class<?> firstParam = m.getParameterTypes()[0];
        return firstParam.getSimpleName();
    }

    public static void main(String[] args) throws SrvDefineException {
        List<SrvDefine> srvDefine = SrvUnitTools.getSrvDefine(TestServiceUnit.class);
        System.out.println(srvDefine);
    }

    static {
        eventDefine.add(BadRequestEvent.class.getName());
        eventDefine.add(InstallProcHandlerEvent.class.getName());
        eventDefine.add(ServiceUnitRegisterEvent.class.getName());
        eventDefine.add(RequestForwardEvent.class.getName());
        eventDefine.add(ShellInputEvent.class.getName());
        eventDefine.add(StatementCommitEvent.class.getName());
        eventDefine.add(UserTypingEvent.class.getName());
    }
}

