/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.processor;

import com.ksptooi.guice.annotations.Unit;
import com.ksptooi.psm.processor.EventSchedule;
import com.ksptooi.psm.processor.ShellRequest;
import com.ksptooi.psm.processor.entity.Process;
import com.ksptooi.psm.processor.event.task.AsyncProcessCommitEvent;
import com.ksptooi.psm.processor.event.task.AsyncProcessExitEvent;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.server.channel.ChannelSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unit
public class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    private int nextPid = 1;
    private final TreeSet<Integer> availablePids = new TreeSet();
    private final Map<Integer, Process> tasks = new ConcurrentHashMap<Integer, Process>();
    @Inject
    private EventSchedule eventSchedule;

    public void commit(Process task) {
        ShellRequest request = task.getRequest();
        ChannelSession session = request.getShell().getSession();
        String taskName = task.getTaskName();
        String username = session.getSession().getUsername();
        int pid = this.takePid();
        task.setPid(pid);
        task.setStage(Process.STAGE_RUNNING);
        this.tasks.put(task.getPid(), task);
        log.info("\u7528\u6237:{} \u542f\u52a8\u8fdb\u7a0b:{} PID:{}", new Object[]{username, taskName, task.getPid()});
        Thread thread = Thread.ofVirtual().name(taskName).start(() -> {
            AsyncProcessCommitEvent event = new AsyncProcessCommitEvent(task);
            this.eventSchedule.forward(event);
            request.getShell().toggleCurrentProcess(task);
            try {
                task.getTarget().invoke(task.getServiceUnit().getSrvUnit(), task.getInjectParams());
            }
            catch (Exception e) {
                if (e.getCause() instanceof InterruptedException) {
                    log.info("\u8fdb\u7a0b\u88ab\u4e2d\u6b62:{}", (Object)taskName);
                }
                e.printStackTrace();
            }
            this.releaseTask(task);
            AsyncProcessExitEvent exit = new AsyncProcessExitEvent(task);
            this.eventSchedule.forward(exit);
            request.getShell().toggleCurrentProcess();
        });
        task.setInstance(thread);
    }

    public void kill(int pid) {
        Process t = this.tasks.get(pid);
        if (t == null || t.getStage() != Process.STAGE_RUNNING.intValue() || t.getInstance() == null) {
            return;
        }
        this.releaseTask(t);
        Thread instance = t.getInstance();
        instance.interrupt();
    }

    private void releaseTask(Process t) {
        if (!this.tasks.containsKey(t.getPid())) {
            return;
        }
        this.tasks.remove(t.getPid());
        t.setStage(Process.STAGE_FINISHED);
        this.releasePid(t.getPid());
        t.getFinishHook().finished();
        t.getRequest().getCable().destroy();
    }

    private synchronized int takePid() {
        if (this.availablePids.isEmpty()) {
            return this.nextPid++;
        }
        return this.availablePids.pollFirst();
    }

    private synchronized void releasePid(int pid) {
        this.availablePids.add(pid);
    }

    public Map<Integer, Process> getTasks() {
        return this.tasks;
    }
}

