/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.shell;

import com.ksptooi.psm.processor.EventSchedule;
import com.ksptooi.psm.processor.ServiceUnitManager;
import com.ksptooi.psm.processor.ShellRequest;
import com.ksptooi.psm.processor.TaskManager;
import com.ksptooi.psm.processor.entity.HookTaskFinished;
import com.ksptooi.psm.processor.entity.Process;
import com.ksptooi.psm.processor.event.ShellInputEvent;
import com.ksptooi.psm.processor.event.StatementCommitEvent;
import com.ksptooi.psm.processor.event.UserTypingEvent;
import com.ksptooi.psm.processor.event.generic.ServiceUnitEvent;
import com.ksptooi.psm.shell.VirtualTextArea;
import com.ksptooi.psm.utils.aio.AdvInputOutputCable;
import com.ksptooi.psm.utils.aio.AdvInputOutputPort;
import com.ksptooi.psm.utils.aio.AdvancedInputOutputPort;
import com.ksptooi.psm.utils.aio.ConnectMode;
import com.ksptooi.psm.vk.VK;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;

public class PSMShell
implements Command,
Runnable {
    private ExitCallback exitCallback;
    private OutputStream eos;
    private OutputStream os;
    private PrintWriter pw;
    private InputStream is;
    private ChannelSession session;
    private Environment env;
    @Inject
    private ServiceUnitManager serviceUnitManager;
    @Inject
    private TaskManager taskManager;
    @Inject
    private EventSchedule eventSchedule;
    private Thread shellThread = null;
    private volatile Process currentTask = null;
    private boolean offline = false;
    private AdvancedInputOutputPort shellAioPort;
    private AdvInputOutputCable cable;
    private VirtualTextArea vt;

    public void start(ChannelSession session, Environment env) throws IOException {
        this.session = session;
        this.env = env;
        String v = "4.0A";
        String p = "x64";
        this.shellAioPort = new AdvInputOutputPort(this.is, this.os, env);
        this.cable = this.shellAioPort.createCable();
        this.cable.connect();
        this.cable.print("\u001b[0;36m").print("Welcome To PlatformServiceModule(PSM/").print("4.0A").print(" x64").print(")").print("\u001b[0m").flush();
        this.cable.nextLine().flush();
        this.vt = new VirtualTextArea(this.cable, env);
        this.vt.setHeader(this.getServerSession().getUsername() + "> ");
        this.vt.render();
        this.shellThread = Thread.ofVirtual().start(this);
    }

    public void destroy(ChannelSession session) throws Exception {
        this.offline = true;
        this.shellThread.interrupt();
    }

    public void setExitCallback(ExitCallback exitCallback) {
        this.exitCallback = exitCallback;
    }

    public void setErrorStream(OutputStream os) {
        this.eos = os;
    }

    public void setInputStream(InputStream is) {
        this.is = is;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
        this.pw = new PrintWriter(os);
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.cable.read();
                char[] rc = this.cable.getReadChars();
                int rl = this.cable.getReadLen();
                if (this.triggerEvent(new ShellInputEvent(this, this.cable.getReadChars(), this.cable.getReadLen())).isCanceled()) continue;
                if (this.cable.match(VK.CTRL_C)) {
                    if (this.currentTask == null || this.currentTask.getStage() != Process.STAGE_RUNNING.intValue()) continue;
                    this.taskManager.kill(this.currentTask.getPid());
                    continue;
                }
                this.cable.printDebugText();
                if (this.cable.match(20000)) {
                    if (this.cable.containsCrlf()) {
                        this.pw.print("\u8f93\u5165\u9519\u8bef.");
                        this.pw.flush();
                        continue;
                    }
                    ServiceUnitEvent forward = this.eventSchedule.forward(new UserTypingEvent(this, rc, rl, this.cable.getReadString()));
                    if (forward.isCanceled() || this.currentTask != null) continue;
                    this.vt.insert(this.cable.getReadString());
                    this.vt.render();
                    continue;
                }
                if (this.currentTask != null) continue;
                if (this.cable.match(VK.LEFT)) {
                    this.vt.cursorLeft();
                    this.vt.render();
                    continue;
                }
                if (this.cable.match(VK.RIGHT)) {
                    this.vt.cursorRight();
                    this.vt.render();
                    continue;
                }
                if (this.cable.match(VK.BACKSPACE)) {
                    this.vt.backspace();
                    this.vt.render();
                    continue;
                }
                if (!this.cable.match(VK.ENTER) || this.vt.isBlank()) continue;
                StatementCommitEvent commitEvent = new StatementCommitEvent(this, this.vt.getContent());
                this.eventSchedule.forward(commitEvent);
                if (commitEvent.isCanceled()) {
                    this.vt.render();
                    continue;
                }
                String statement = this.vt.getContent();
                this.vt.reset();
                this.cable.nextLine();
                ShellRequest req = new ShellRequest();
                req.setStatement(statement);
                req.setPattern(null);
                req.setParams(new ArrayList<String>());
                req.setParameters(new HashMap<String, String>());
                req.setShell(this);
                req.setCable(this.shellAioPort.createCable());
                HookTaskFinished hook = () -> System.out.println("Exit Hook");
                Process forward = this.serviceUnitManager.forward(req, hook);
                if (forward != null) continue;
                this.vt.render();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    private ServiceUnitEvent triggerEvent(ServiceUnitEvent e) {
        return this.eventSchedule.forward(e);
    }

    public synchronized void toggleCurrentProcess(Process procTask) {
        if (this.currentTask != null && this.currentTask.getStage() != Process.STAGE_FINISHED.intValue()) {
            return;
        }
        if (procTask.getStage() != Process.STAGE_RUNNING.intValue()) {
            return;
        }
        this.currentTask = procTask;
        ShellRequest request = this.currentTask.getRequest();
        AdvInputOutputCable cab = request.getCable();
        cab.isConnect(ConnectMode.OUTPUT);
        cab.connect(ConnectMode.OUTPUT);
    }

    public synchronized void toggleCurrentProcess() {
        if (this.currentTask == null) {
            return;
        }
        AdvInputOutputCable cab = this.currentTask.getRequest().getCable();
        cab.disconnect();
        this.currentTask = null;
        this.cable.connect();
    }

    public synchronized Process getCurrentProcess() {
        return this.currentTask;
    }

    public synchronized boolean hasForegroundTask() {
        if (this.currentTask == null) {
            return false;
        }
        return this.currentTask.getStage() == Process.STAGE_RUNNING.intValue() || this.currentTask.getInstance().isAlive();
    }

    public Environment getEnv() {
        return this.env;
    }

    public ChannelSession getSession() {
        return this.session;
    }

    public ServerSession getServerSession() {
        return this.session.getSession();
    }

    public boolean isOffline() {
        return this.offline;
    }

    public AdvancedInputOutputPort getAioPort() {
        return this.shellAioPort;
    }

    public AdvInputOutputCable getCable() {
        return this.cable;
    }
}

