/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.shell;

import com.google.inject.Provider;
import com.ksptooi.psm.shell.PSMShellFactory;
import com.ksptooi.psm.shell.SimplePasswordAuthenticator;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.ShellFactory;

public class SshServerProvider
implements Provider<SshServer> {
    @Inject
    private PSMShellFactory psmShellFactory;
    @Inject
    private SimplePasswordAuthenticator authenticator;

    public SshServer get() {
        try {
            SshServer sshd = SshServer.setUpDefaultServer();
            sshd.setPort(1100);
            sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
            sshd.setPasswordAuthenticator((PasswordAuthenticator)this.authenticator);
            sshd.setShellFactory((ShellFactory)this.psmShellFactory);
            sshd.setSessionHeartbeat(SessionHeartbeatController.HeartbeatType.IGNORE, TimeUnit.SECONDS, 32L);
            sshd.start();
            return sshd;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

