/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.shell;

import com.ksptooi.psm.utils.aio.AdvInputOutputCable;
import com.ksptooi.psm.utils.aio.ConnectMode;
import org.apache.sshd.server.Environment;

public class VirtualTextArea {
    private final Environment env;
    private final AdvInputOutputCable cable;
    private final StringBuffer buf = new StringBuffer();
    private int vCursor = 0;
    private String header = ">";

    public VirtualTextArea(AdvInputOutputCable cable, Environment env) {
        this.env = env;
        this.cable = cable;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void render() {
        char c;
        int i;
        if (!this.cable.isConnect(ConnectMode.OUTPUT)) {
            return;
        }
        this.cable.print("\r").print("\u001b[K").print("\u001b[2K");
        int columns = Integer.parseInt((String)this.env.getEnv().get("COLUMNS"));
        Object content = this.buf.toString();
        int omitFactorVal = 11 + this.header.length();
        if (((String)content).length() >= columns - omitFactorVal) {
            int more = ((String)content).length() - (columns - omitFactorVal);
            content = ((String)content).substring(0, columns - omitFactorVal);
            content = (String)content + ">>more(" + more + ")";
        }
        this.cable.print(this.header);
        this.cable.print((String)content).print("\r");
        for (i = 0; i < this.header.length(); ++i) {
            c = this.header.charAt(i);
            if (this.isDoubleWidth(c)) {
                this.cable.print("\u001b[C\u001b[C");
                continue;
            }
            this.cable.print("\u001b[C");
        }
        for (i = 0; i < this.vCursor; ++i) {
            c = this.buf.charAt(i);
            if (this.isDoubleWidth(c)) {
                this.cable.print("\u001b[C\u001b[C");
                continue;
            }
            this.cable.print("\u001b[C");
        }
        this.cable.flush();
    }

    public void cursorUp() {
    }

    public void cursorDown() {
    }

    public void cursorLeft() {
        if (this.vCursor < 1) {
            return;
        }
        --this.vCursor;
    }

    public void cursorRight() {
        if (this.vCursor >= this.buf.length()) {
            return;
        }
        ++this.vCursor;
    }

    public void insert(String str) {
        if (this.vCursor != this.buf.length()) {
            this.buf.insert(this.vCursor, str);
        } else {
            this.buf.append(str);
        }
        this.vCursor += str.length();
    }

    public void backspace() {
        if (this.vCursor < 1) {
            return;
        }
        this.buf.deleteCharAt(this.vCursor - 1);
        --this.vCursor;
    }

    public String getContent() {
        return this.buf.toString();
    }

    public void reset() {
        this.buf.setLength(0);
        this.vCursor = 0;
    }

    private boolean isDoubleWidth(char c) {
        return c > '\u007f';
    }

    public boolean isBlank() {
        if (this.vCursor < 1) {
            return true;
        }
        return this.buf.isEmpty() || this.buf.toString().trim().isEmpty();
    }
}

