/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.subsystem;

import com.ksptooi.Application;
import com.ksptooi.guice.annotations.Unit;
import com.ksptooi.psm.processor.ServiceUnit;
import com.ksptooi.psm.processor.ServiceUnitManager;
import com.ksptooi.psm.processor.SrvUnitTools;
import com.ksptooi.psm.subsystem.SubSystem;
import com.ksptooi.psm.subsystem.entity.ActivatedSubSystem;
import com.ksptooi.psm.subsystem.entity.DiscoveredSubSystem;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unit
public class SubSystemManager {
    private static final Logger log = LoggerFactory.getLogger(SubSystemManager.class);
    private final List<ActivatedSubSystem> installed = new ArrayList<ActivatedSubSystem>();
    @Inject
    private ServiceUnitManager serviceUnitManager;

    public void install(List<DiscoveredSubSystem> dss) {
        for (DiscoveredSubSystem item : dss) {
            if (this.exists(item.getName())) {
                log.error("cannot install subsystem {} because the same name is already installed.", (Object)item.getName());
                continue;
            }
            SubSystem entryInstance = null;
            try {
                Object instance = item.getEntry().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(instance instanceof SubSystem)) {
                    log.error("[\u65e0\u6cd5\u5b89\u88c5] \u5b50\u7cfb\u7edf {} \u5df2\u635f\u574f. \u56e0\u4e3a\u5176\u5165\u53e3\u6ca1\u6709\u7ee7\u627f\u81eaSubSystem.", (Object)item.getName());
                    continue;
                }
                entryInstance = (SubSystem)instance;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            Set processorDefine = item.getReflections().getTypesAnnotatedWith(ServiceUnit.class);
            this.serviceUnitManager.register(SrvUnitTools.getSrvUnitInstance(processorDefine));
            this.serviceUnitManager.installRequestHandler();
            this.serviceUnitManager.installEventHandler();
            ActivatedSubSystem activated = new ActivatedSubSystem();
            activated.setJarFile(item.getJarFile());
            activated.setName(item.getName());
            activated.setVersion(item.getVersion());
            activated.setEntry(entryInstance);
            activated.setClassLoader(item.getClassLoader());
            activated.setReflections(item.getReflections());
            activated.setProcessorDefine(processorDefine.stream().toList());
            this.installed.add(activated);
            log.info("\u5b50\u7cfb\u7edf {}-{} \u5df2\u5b89\u88c5", (Object)item.getName(), (Object)item.getVersion());
            Application.injector.injectMembers((Object)entryInstance);
            entryInstance.onActivated();
        }
    }

    public void uninstall(ActivatedSubSystem ass) {
    }

    public boolean exists(String name) {
        for (ActivatedSubSystem subsystem : this.installed) {
            if (!subsystem.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ActivatedSubSystem getSubSystem(String name) {
        return null;
    }

    public ActivatedSubSystem getSubSystem(String n, String v) {
        return null;
    }
}

