/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.utils.aio;

import com.ksptooi.psm.utils.aio.AdvInputOutputCable;
import com.ksptooi.psm.utils.aio.AdvancedInputOutputPort;
import com.ksptooi.psm.utils.aio.ConnectMode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Queue;
import org.apache.sshd.server.Environment;
import xyz.downgoon.snowflake.Snowflake;

public class AdvInputOutputPort
implements AdvancedInputOutputPort {
    private final Snowflake snowflake = new Snowflake(2L, 16L);
    private final InputStream is;
    private final OutputStream os;
    private final Environment env;
    private final BufferedReader br;
    private final PrintWriter p;
    private Queue<char[]> cableInput;
    private Queue<String> cableOutput;
    private volatile AdvInputOutputCable inputCable;
    private volatile AdvInputOutputCable outputCable;

    public AdvInputOutputPort(InputStream is, OutputStream os, Environment env) {
        this.is = is;
        this.os = os;
        this.env = env;
        this.p = new PrintWriter(os);
        this.br = new BufferedReader(new InputStreamReader(is));
    }

    @Override
    public int read(AdvInputOutputCable cable, char[] c) throws IOException {
        if (!this.isConnect(cable, ConnectMode.INPUT)) {
            throw new RuntimeException("cannot flush. the cable is not connected to the output on this port");
        }
        int read = this.br.read(c);
        if (read == -1) {
            throw new IOException();
        }
        return read;
    }

    @Override
    public void flush(AdvInputOutputCable cable) {
        if (!this.isConnect(cable, ConnectMode.OUTPUT)) {
            throw new RuntimeException("cannot flush. the cable is not connected to the output on this port");
        }
        Iterator itr = this.cableOutput.iterator();
        while (itr.hasNext()) {
            this.p.print((String)itr.next());
        }
        this.p.flush();
        this.cableOutput.clear();
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public AdvInputOutputCable createCable() {
        return new AdvInputOutputCable(this.snowflake.nextId(), this);
    }

    @Override
    public void connect(AdvInputOutputCable cable, ConnectMode type, Queue<char[]> is, Queue<String> os) {
        this.ensureBindThisPort(cable);
        if (type.val() == ConnectMode.INPUT.val()) {
            this.inputCable = cable;
            this.cableInput = is;
        }
        if (type.val() == ConnectMode.OUTPUT.val()) {
            this.outputCable = cable;
            this.cableOutput = os;
            this.flush(cable);
        }
    }

    @Override
    public void disconnect(ConnectMode type) {
        if (type.val() == ConnectMode.INPUT.val()) {
            this.inputCable = null;
            this.cableInput = null;
        }
        if (type.val() == ConnectMode.OUTPUT.val()) {
            this.outputCable = null;
            this.cableOutput = null;
        }
    }

    @Override
    public boolean isConnect(AdvInputOutputCable cable, ConnectMode t) {
        this.ensureBindThisPort(cable);
        if (t.val() == ConnectMode.INPUT.val()) {
            if (this.inputCable == null) {
                return false;
            }
            return this.inputCable.getId() == cable.getId();
        }
        if (t.val() == ConnectMode.OUTPUT.val()) {
            if (this.outputCable == null) {
                return false;
            }
            return this.outputCable.getId() == cable.getId();
        }
        return false;
    }

    @Override
    public long getCurrentCableId(ConnectMode t) {
        if (t.val() == ConnectMode.INPUT.val()) {
            return this.inputCable == null ? -1L : this.inputCable.getId();
        }
        if (t.val() == ConnectMode.OUTPUT.val()) {
            return this.outputCable == null ? -1L : this.outputCable.getId();
        }
        return -1L;
    }

    private void ensureBindThisPort(AdvInputOutputCable cable) {
        if (!cable.getPort().equals(this)) {
            throw new RuntimeException("Cable\u6ca1\u6709\u7ed1\u5b9a\u5230\u5f53\u524d\u7684Port");
        }
    }

    public Environment getEnv() {
        return this.env;
    }
}

