/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.commons;

import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.util.Date;

public class IdWorker {
    private static final long twepoch = 1288834974657L;
    private static final long workerIdBits = 2L;
    private static final long datacenterIdBits = 2L;
    private static final long maxWorkerId = 3L;
    private static final long maxDatacenterId = 3L;
    private static final long sequenceBits = 10L;
    private static final long workerIdShift = 10L;
    private static final long datacenterIdShift = 12L;
    private static final long timestampLeftShift = 14L;
    private static final long sequenceMask = 1023L;
    private static long lastTimestamp = -1L;
    private long sequence = 0L;
    private final long workerId;
    private final long datacenterId;

    public IdWorker() {
        this.datacenterId = IdWorker.getDatacenterId(3L);
        this.workerId = IdWorker.getMaxWorkerId(this.datacenterId, 3L);
    }

    public IdWorker(long workerId, long datacenterId) {
        if (workerId > 3L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 3L));
        }
        if (datacenterId > 3L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 3L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        lastTimestamp = timestamp;
        long nextId = timestamp - 1288834974657L << 14 | this.datacenterId << 12 | this.workerId << 10 | this.sequence;
        return nextId;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    protected static long getMaxWorkerId(long datacenterId, long maxWorkerId) {
        StringBuffer mpid = new StringBuffer();
        mpid.append(datacenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (!name.isEmpty()) {
            mpid.append(name.split("@")[0]);
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    protected static long getDatacenterId(long maxDatacenterId) {
        long id = 0L;
        try {
            NetworkInterface network = null;
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                id %= maxDatacenterId + 1L;
            }
        }
        catch (Exception e) {
            System.out.println(" getDatacenterId: " + e.getMessage());
        }
        return id;
    }

    public static void main(String[] args) {
        IdWorker idWorker = new IdWorker(0L, 0L);
        for (int i = 0; i < 1000; ++i) {
            long nextId = idWorker.nextId();
            System.out.println(nextId);
        }
        System.out.println(new Date().getTime());
    }
}

