/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.core.service;

import com.google.inject.Inject;
import com.ksptooi.uac.commons.IdWorker;
import com.ksptooi.uac.core.entities.Command;
import com.ksptooi.uac.core.mapper.CommandMapper;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandService {
    private Logger logger = LoggerFactory.getLogger(CommandService.class);
    @Inject
    private CommandMapper mapper;
    private final IdWorker idWorker = new IdWorker();

    public Command getCommandByName(String name) {
        Command query = new Command();
        query.setName(name);
        List<Command> commandList = this.mapper.getCommandList(query);
        if (commandList.size() < 1) {
            return null;
        }
        return commandList.get(0);
    }

    public List<Command> getCommandByProcessorName(String processorName) {
        Command query = new Command();
        query.setExecutorName(processorName);
        return this.mapper.getCommandList(query);
    }

    public boolean insert(Command inVo) {
        if (this.hasCommand(inVo.getName())) {
            this.logger.info("\u5c1d\u8bd5\u6dfb\u52a0\u547d\u4ee4" + inVo.getName() + "\u5931\u8d25,\u8be5\u547d\u4ee4\u5df2\u5b58\u5728!");
            return false;
        }
        inVo.setCmdId(this.idWorker.nextId());
        inVo.setCreateTime(new Date());
        this.logger.info("\u547d\u4ee4\"" + inVo.getName() + "\"\u65b0\u589e\u6210\u529f!");
        this.mapper.insert(inVo);
        return true;
    }

    public boolean update(Command inVo) {
        if (!this.hasCommand(inVo.getName())) {
            this.logger.info("\u5c1d\u8bd5\u4fee\u6539\u547d\u4ee4" + inVo.getName() + "\u5931\u8d25,\u8be5\u547d\u4ee4\u4e0d\u5b58\u5728!");
            return false;
        }
        this.logger.info("\u547d\u4ee4\"" + inVo.getName() + "\"\u4fee\u6539\u6210\u529f!");
        this.mapper.update(inVo);
        return true;
    }

    public boolean hasCommand(String name) {
        return this.getCommandByName(name) != null;
    }

    public boolean removeById(String id) {
        this.mapper.removeById(id);
        return true;
    }
}

