/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.core.service;

import com.google.inject.Inject;
import com.ksptooi.uac.commons.IdWorker;
import com.ksptooi.uac.core.entities.Document;
import com.ksptooi.uac.core.mapper.DocumentMapper;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentService {
    private final Logger logger = LoggerFactory.getLogger(DocumentService.class);
    @Inject
    private DocumentMapper mapper;
    private final IdWorker idWorker = new IdWorker();

    public Document getDocumentById(Long id) {
        return this.mapper.getDocumentById(id);
    }

    public Document getDocumentByName(String name) {
        return this.mapper.getDocumentByName(name);
    }

    public List<Document> getDocumentList(Document document) {
        return this.mapper.getDocumentList(document);
    }

    public List<Document> getDocumentByType(String documentType) {
        return this.mapper.getDocumentByType(documentType);
    }

    public Document createDocument(String name) {
        return this.createDocument(name, null);
    }

    public Document createDocument(String name, String type) {
        if (this.getDocumentByName(name) != null) {
            this.logger.info("\u6587\u6863\u540d\u79f0\u5df2\u88ab\u5360\u7528:{}", (Object)name);
            return null;
        }
        Document dom = new Document();
        dom.setDocId(this.idWorker.nextId());
        dom.setName(name);
        dom.setDomType(type);
        dom.setMetadata(null);
        dom.setBinaryData(null);
        dom.setDescription("document");
        dom.setCreateTime(new Date());
        boolean insert = this.insert(dom);
        if (!insert) {
            return null;
        }
        return dom;
    }

    public boolean hasDocument(String name) {
        Document documentByName = this.getDocumentByName(name);
        return documentByName != null;
    }

    public boolean insert(Document in) {
        if (this.getDocumentByName(in.getName()) != null) {
            this.logger.info("\u6587\u6863\u540d\u79f0\u5df2\u88ab\u5360\u7528:{}", (Object)in.getName());
            return false;
        }
        if (in.getName() == null || in.getName().trim().equals("")) {
            this.logger.info("\u6587\u6863\u540d\u79f0\u4e3a\u7a7a:{}", (Object)in.getName());
            return false;
        }
        in.setDocId(this.idWorker.nextId());
        in.setCreateTime(new Date());
        this.mapper.insert(in);
        return true;
    }

    public boolean update(Document in) {
        Document update = this.getDocumentById(in.getDocId());
        if (update == null) {
            this.logger.info("\u4fee\u6539\u5931\u8d25,\u6587\u6863\u4e0d\u5b58\u5728.ID:{}", (Object)in.getDocId());
            return false;
        }
        update.setMetadata(in.getMetadata());
        update.setBinaryData(in.getBinaryData());
        update.setDescription(in.getDescription());
        this.mapper.update(in);
        return true;
    }

    public boolean removeById(Long id) {
        try {
            this.mapper.remove(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public String queryMetadata(String inDocName) {
        Document documentByName = this.getDocumentByName(inDocName);
        if (documentByName == null) {
            return null;
        }
        return documentByName.getMetadata();
    }

    public boolean updateMetadata(String inDomName, String metadata) {
        Document documentByName = this.getDocumentByName(inDomName);
        if (documentByName == null) {
            return false;
        }
        documentByName.setMetadata(metadata);
        this.update(documentByName);
        return true;
    }

    public InputStream getBinaryData(Long docId) {
        return this.mapper.getBinaryData(docId);
    }

    public void updateBinaryData(Long docId, InputStream is) {
        this.mapper.updateBinaryData(docId, is);
    }

    public Long getBinaryLength(Long docId) {
        return this.mapper.getBinaryDataLength(docId);
    }
}

