/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.extendsbuildin.processor;

import com.google.inject.Inject;
import com.ksptooi.uac.core.annatatiotion.CommandMapping;
import com.ksptooi.uac.core.annatatiotion.Param;
import com.ksptooi.uac.core.annatatiotion.Processor;
import com.ksptooi.uac.core.entities.CliCommand;
import com.ksptooi.uac.core.entities.Command;
import com.ksptooi.uac.core.processor.ProcessorAdapter;
import com.ksptooi.uac.extendsbuildin.service.ApplicationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Processor(value="build-in-AppProcessor")
public class AppProcessor
extends ProcessorAdapter {
    private final Logger logger = LoggerFactory.getLogger(AppProcessor.class);
    @Inject
    private ApplicationService service;

    @CommandMapping(value={"app i", "app install"})
    public void appInstall(@Param(value="appName") String appName, @Param(value="path") String path, CliCommand inCommand) {
        String save = null;
        if (inCommand.getParameter().size() > 2) {
            save = inCommand.getParameter().get(2);
        }
        this.logger.info("\u6b63\u5728\u4ece\u8def\u5f84\u5b89\u88c5\u5e94\u7528...");
        Command command = this.service.appInstall(appName, path);
        if (save == null || command == null) {
            return;
        }
        if (save.equals("save")) {
            this.logger.info("\u6b63\u5728\u4fdd\u5b58\u5e94\u7528...");
            this.service.saveAsDocument(command);
        }
    }

    @CommandMapping(value={"app rm", "app remove"})
    public void appRemove(@Param(value="appName") String appName) {
        this.service.appRemove(appName);
    }

    @CommandMapping(value={"app l", "app list"})
    public void appList(CliCommand preparedCommand) {
        this.service.appShow();
    }

    @Override
    public String[] defaultCommand() {
        return new String[]{"app install", "app i", "app remove", "app rm", "app list", "app l", "app install save", "app i s"};
    }

    @Override
    public void onCommand(CliCommand preparedCommand, Command command) {
    }
}

