/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.extendsbuildin.processor;

import com.google.inject.Inject;
import com.ksptooi.uac.core.annatatiotion.CommandMapping;
import com.ksptooi.uac.core.annatatiotion.Param;
import com.ksptooi.uac.core.annatatiotion.Processor;
import com.ksptooi.uac.core.entities.CliCommand;
import com.ksptooi.uac.core.entities.Command;
import com.ksptooi.uac.core.processor.ProcessorAdapter;
import com.ksptooi.uac.core.service.DatabaseService;
import com.ksptooi.uac.extendsbuildin.service.CommandOperateService;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Processor(value="build-in-CmdOperateProcessor")
public class CmdOperateProcessor
extends ProcessorAdapter {
    private final Logger logger = LoggerFactory.getLogger(CmdOperateProcessor.class);
    @Inject
    private CommandOperateService service;
    @Inject
    private DatabaseService dbService;

    @Override
    public String[] defaultCommand() {
        return new String[]{"cmd list", "cmd l", "cmd refresh", "cmd r", "help", "db trim", "db export", "db import"};
    }

    @CommandMapping(value={"db trim"})
    public void dbTrim() {
        this.dbService.trim();
    }

    @CommandMapping(value={"db export"})
    public void dbExport(@Param(value="path") String path) {
        Path p = null;
        try {
            p = Paths.get(path, new String[0]);
        }
        catch (Exception e) {
            this.logger.info("\u65e0\u6cd5\u89e3\u6790\u8def\u5f84:{}", (Object)path);
        }
        if (p == null) {
            return;
        }
        this.dbService.export(p);
    }

    @CommandMapping(value={"db import"})
    public void dbImport(@Param(value="path") String path) {
        Path p = null;
        try {
            p = Paths.get(path, new String[0]);
        }
        catch (Exception e) {
            this.logger.info("\u65e0\u6cd5\u89e3\u6790\u8def\u5f84:{}", (Object)path);
        }
        if (p == null) {
            return;
        }
        this.dbService.dbImport(p);
    }

    @CommandMapping(value={"cmd l", "cmd list"})
    public void list() {
        this.service.listAll();
    }

    @CommandMapping(value={"cmd refresh", "cmd r"})
    public void refreshCommand() {
        this.service.refreshCommand();
    }

    @CommandMapping(value={"help"})
    public void helpCommand() {
        this.service.listAll();
    }

    @Override
    public void onCommand(CliCommand preparedCommand, Command command) {
    }
}

