/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.HttpSession;
import com.kttdevelopment.simplehttpserver.HttpSessionHandler;
import com.kttdevelopment.simplehttpserver.handler.ConnectionThrottler;
import com.sun.net.httpserver.HttpExchange;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SessionThrottler
extends ConnectionThrottler {
    private final HttpSessionHandler sessionHandler;
    private final Map<HttpSession, AtomicInteger> connections = new ConcurrentHashMap<HttpSession, AtomicInteger>();

    public SessionThrottler(HttpSessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    @Override
    final boolean addConnection(HttpExchange exchange) {
        HttpSession session = this.sessionHandler.getSession(exchange);
        int maxConn = this.getMaxConnections(session, exchange);
        if (!this.connections.containsKey(session)) {
            this.connections.put(session, new AtomicInteger(0));
        }
        AtomicInteger conn = this.connections.get(session);
        if (maxConn < 0) {
            conn.incrementAndGet();
            return true;
        }
        AtomicBoolean added = new AtomicBoolean(false);
        conn.updateAndGet(operand -> {
            if (operand < maxConn) {
                added.set(true);
            }
            return operand < maxConn ? operand + 1 : operand;
        });
        return added.get();
    }

    @Override
    final void deleteConnection(HttpExchange exchange) {
        HttpSession session = this.sessionHandler.getSession(exchange);
        if (this.connections.containsKey(session)) {
            this.connections.get(session).decrementAndGet();
        }
    }

    @Override
    public final int getMaxConnections(HttpExchange exchange) {
        return this.getMaxConnections(this.sessionHandler.getSession(exchange), exchange);
    }

    public int getMaxConnections(HttpSession session, HttpExchange exchange) {
        return -1;
    }

    public String toString() {
        return "SessionThrottler{sessionHandler=" + this.sessionHandler + ", connections=" + this.connections.toString() + "}";
    }
}

