/*
 * Decompiled with CFR 0.152.
 */
package com.lingocoder.compatibility.java.versions;

import com.lingocoder.compatibility.gradle.GradleJavaVersions;
import com.lingocoder.compatibility.gradle.UnknownVersionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.Severity;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class Versions
implements BuildService<Params>,
AutoCloseable {
    private final ProblemReporter problemReporter;
    private static final ProblemGroup GROUP = ProblemGroup.create((String)"com.lingocoder.plugin.mrjar-problems", (String)"Version Compatibility Problems");
    private static final ProblemId WARN_ID = ProblemId.create((String)"unsupported-version", (String)"Unsupported Version", (ProblemGroup)GROUP);
    private static final ProblemId FAIL_ID = ProblemId.create((String)"forbidden-recipient", (String)"Forbidden recipient 'fail'", (ProblemGroup)GROUP);
    private final GradleJavaVersions gradleJavaVersions;

    @Override
    public void close() {
    }

    @Inject
    public Versions(Problems problems) {
        this.problemReporter = problems.getReporter();
        this.gradleJavaVersions = new GradleJavaVersions();
    }

    public Set<JavaVersion> supported() {
        Collection<Object> supported = Arrays.asList(JavaVersion.VERSION_11, JavaVersion.VERSION_17);
        try {
            supported = this.gradleJavaVersions.supportedVersions();
        }
        catch (UnknownVersionException uve) {
            System.out.println("In Version.supported()'s catch(UnknownVersionException) Before Report");
            this.problemReporter.report(WARN_ID, builder -> builder.details("unknown version 'x'").solution("Please use known version 'y'").severity(Severity.WARNING));
            System.out.println("In Version.supported()'s catch(UnknownVersionException) After Report");
        }
        return Collections.unmodifiableSet(new ConcurrentSkipListSet<JavaVersion>(supported));
    }

    public static interface Params
    extends BuildServiceParameters {
    }
}

