/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.template;

import com.litongjava.tio.utils.hutool.ResourceUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SqlTemplates {
    private static Map<String, String> sqlTemplates = null;

    public static void load(String mainFilePath) {
        SqlTemplates.parseSQLFile(mainFilePath);
    }

    public static void load() {
        SqlTemplates.parseSQLFile("sql-templates/main.sql");
    }

    private static void parseSQLFile(String filePath) {
        List lines;
        URL resource;
        if (sqlTemplates == null) {
            sqlTemplates = new HashMap<String, String>();
        }
        if ((resource = ResourceUtil.getResource((String)filePath)) == null) {
            throw new RuntimeException();
        }
        try {
            InputStream inputStream = resource.openStream();
            Object object = null;
            try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(inputStream));){
                lines = reader2.lines().collect(Collectors.toList());
            }
            catch (Throwable reader2) {
                object = reader2;
                throw reader2;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable reader2) {
                            ((Throwable)object).addSuppressed(reader2);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String currentID = null;
        for (String line : lines) {
            String[] parts;
            if ((line = line.trim()).startsWith("--#")) {
                parts = line.split("\\s+");
                if (parts.length <= 1) continue;
                currentID = parts[1];
                sqlTemplates.put(currentID, "");
                continue;
            }
            if (line.startsWith("--@")) {
                parts = line.split("\\s+");
                if (parts.length <= 1) continue;
                String includedFilePath = Paths.get(filePath, new String[0]).getParent().toString() + "/" + parts[1];
                SqlTemplates.parseSQLFile(includedFilePath);
                continue;
            }
            if (currentID == null) continue;
            sqlTemplates.put(currentID, sqlTemplates.get(currentID) + line + "\n");
        }
    }

    public static String get(String sqlId) throws IllegalArgumentException {
        String sql;
        if (sqlTemplates == null) {
            SqlTemplates.load();
        }
        if ((sql = sqlTemplates.get(sqlId)) == null) {
            throw new IllegalArgumentException("SQL ID not found+" + sql);
        }
        return sql;
    }

    public static Map<String, String> getAll() {
        if (sqlTemplates == null) {
            SqlTemplates.load();
        }
        return sqlTemplates;
    }
}

