/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord;

import com.jfinal.kit.Kv;
import com.jfinal.kit.TypeKit;
import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.DbKit;
import com.litongjava.db.activerecord.Model;
import com.litongjava.model.db.IRow;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.postgresql.util.PGobject;

public class Row
implements IRow<Row>,
Serializable {
    private static final long serialVersionUID = 905784513600884082L;
    private Map<String, Object> columns;
    private String tableName;
    Set<String> modifyFlag;

    public String getTableName() {
        return this.tableName;
    }

    public Row setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    Set<String> _getModifyFlag() {
        if (this.modifyFlag == null) {
            Config config = DbKit.getConfig();
            this.modifyFlag = config == null ? DbKit.brokenConfig.containerFactory.getModifyFlagSet() : config.containerFactory.getModifyFlagSet();
        }
        return this.modifyFlag;
    }

    void clearModifyFlag() {
        if (this.modifyFlag != null) {
            this.modifyFlag.clear();
        }
    }

    public Row setContainerFactoryByConfigName(String configName) {
        Config config = DbKit.getConfig(configName);
        if (config == null) {
            throw new IllegalArgumentException("Config not found: " + configName);
        }
        this.processColumnsMap(config);
        return this;
    }

    void setColumnsMap(Map<String, Object> columns) {
        this.columns = columns;
    }

    private void processColumnsMap(Config config) {
        if (this.columns == null || this.columns.size() == 0) {
            this.columns = config.containerFactory.getColumnsMap();
        } else {
            Map<String, Object> columnsOld = this.columns;
            this.columns = config.containerFactory.getColumnsMap();
            this.columns.putAll(columnsOld);
        }
    }

    public Map<String, Object> getColumns() {
        if (this.columns == null) {
            this.columns = DbKit.config == null ? DbKit.brokenConfig.containerFactory.getColumnsMap() : DbKit.config.containerFactory.getColumnsMap();
        }
        return this.columns;
    }

    public Row setColumns(Map<String, Object> columns) {
        for (Map.Entry<String, Object> e : columns.entrySet()) {
            this.set(e.getKey(), e.getValue());
        }
        return this;
    }

    public Row setColumns(Row record) {
        return this.setColumns(record.getColumns());
    }

    public Row setColumns(Model<?> model) {
        return this.setColumns(model._getAttrs());
    }

    public Row remove(String column) {
        this.getColumns().remove(column);
        this._getModifyFlag().remove(column);
        return this;
    }

    public Row remove(String ... columns) {
        if (columns != null) {
            for (String c : columns) {
                this.getColumns().remove(c);
                this._getModifyFlag().remove(c);
            }
        }
        return this;
    }

    public Row removeNullValueColumns() {
        Iterator<Map.Entry<String, Object>> it = this.getColumns().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            if (e.getValue() != null) continue;
            it.remove();
            this._getModifyFlag().remove(e.getKey());
        }
        return this;
    }

    public Row keep(String ... columns) {
        if (columns != null && columns.length > 0) {
            Config config = DbKit.getConfig();
            if (config == null) {
                config = DbKit.brokenConfig;
            }
            Map newColumns = config.containerFactory.getColumnsMap();
            Set newModifyFlag = config.containerFactory.getModifyFlagSet();
            for (String c : columns) {
                if (this.getColumns().containsKey(c)) {
                    newColumns.put(c, this.columns.get(c));
                }
                if (!this._getModifyFlag().contains(c)) continue;
                newModifyFlag.add(c);
            }
            this.columns = newColumns;
            this.modifyFlag = newModifyFlag;
        } else {
            this.getColumns().clear();
            this.clearModifyFlag();
        }
        return this;
    }

    public Row keep(String column) {
        if (this.getColumns().containsKey(column)) {
            Object keepIt = this.getColumns().get(column);
            this.getColumns().clear();
            this.getColumns().put(column, keepIt);
            boolean keepFlag = this._getModifyFlag().contains(column);
            this.clearModifyFlag();
            if (keepFlag) {
                this._getModifyFlag().add(column);
            }
        } else {
            this.getColumns().clear();
            this.clearModifyFlag();
        }
        return this;
    }

    public Row clear() {
        this.getColumns().clear();
        this.clearModifyFlag();
        return this;
    }

    public Row set(String column, Object value) {
        this.getColumns().put(column, value);
        this._getModifyFlag().add(column);
        return this;
    }

    public <T> T get(String column) {
        return (T)this.getColumns().get(column);
    }

    public String[] getStringArray(String column) {
        Object object = this.getColumns().get(column);
        if (object != null) {
            return (String[])object;
        }
        return null;
    }

    public <T> T get(String column, Object defaultValue) {
        Object result = this.getColumns().get(column);
        return (T)(result != null ? result : defaultValue);
    }

    public Object getObject(String column) {
        return this.getColumns().get(column);
    }

    public Object getObject(String column, Object defaultValue) {
        Object result = this.getColumns().get(column);
        return result != null ? result : defaultValue;
    }

    public String getStr(String column) {
        Object s = this.getColumns().get(column);
        return s != null ? s.toString() : null;
    }

    public String getString(String column) {
        Object s = this.getColumns().get(column);
        return s != null ? s.toString() : null;
    }

    public Integer getInt(String column) {
        return TypeKit.toInt((Object)this.getColumns().get(column));
    }

    public Long getLong(String column) {
        return TypeKit.toLong((Object)this.getColumns().get(column));
    }

    public BigInteger getBigInteger(String column) {
        Object n = this.getColumns().get(column);
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).toBigInteger();
        }
        if (n instanceof Number) {
            return BigInteger.valueOf(((Number)n).longValue());
        }
        if (n instanceof String) {
            return new BigInteger((String)n);
        }
        return (BigInteger)n;
    }

    public Date getDate(String column) {
        return TypeKit.toDate((Object)this.getColumns().get(column));
    }

    public LocalDateTime getLocalDateTime(String column) {
        return TypeKit.toLocalDateTime((Object)this.getColumns().get(column));
    }

    public Time getTime(String column) {
        return (Time)this.getColumns().get(column);
    }

    public Timestamp getTimestamp(String column) {
        return (Timestamp)this.getColumns().get(column);
    }

    public OffsetDateTime getOffsetDateTime(String column) {
        Timestamp ts = this.getTimestamp(column);
        if (ts != null) {
            return ts.toInstant().atOffset(ZoneOffset.UTC);
        }
        return null;
    }

    public Double getDouble(String column) {
        return TypeKit.toDouble((Object)this.getColumns().get(column));
    }

    public Float getFloat(String column) {
        return TypeKit.toFloat((Object)this.getColumns().get(column));
    }

    public Short getShort(String column) {
        return TypeKit.toShort((Object)this.getColumns().get(column));
    }

    public Byte getByte(String column) {
        return TypeKit.toByte((Object)this.getColumns().get(column));
    }

    public Boolean getBoolean(String column) {
        return TypeKit.toBoolean((Object)this.getColumns().get(column));
    }

    public BigDecimal getBigDecimal(String column) {
        return TypeKit.toBigDecimal((Object)this.getColumns().get(column));
    }

    public byte[] getBytes(String column) {
        return (byte[])this.getColumns().get(column);
    }

    public Number getNumber(String column) {
        return TypeKit.toNumber((Object)this.getColumns().get(column));
    }

    public <K, V> Map<K, V> getMap(String column) {
        Object object = this.getColumns().get(column);
        if (object instanceof Map) {
            return (Map)object;
        }
        throw new RuntimeException(column + " is not type of map");
    }

    public PGobject getPGobject(String column) {
        Object object = this.getColumns().get(column);
        return (PGobject)object;
    }

    public <T> T getAs(String column) {
        Object object = this.getColumns().get(column);
        return (T)object;
    }

    public <T> List<T> getList(String column) {
        Object object = this.getColumns().get(column);
        if (object instanceof List) {
            return (List)object;
        }
        throw new RuntimeException(column + " is not type of list");
    }

    public String toString() {
        if (this.columns == null) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, Object> e : this.getColumns().entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object value = e.getValue();
            if (value != null) {
                value = value.toString();
            }
            sb.append(e.getKey()).append(':').append(value);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Row)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.getColumns().equals(((Row)o).getColumns());
    }

    public int hashCode() {
        return this.getColumns().hashCode();
    }

    public String[] getColumnNames() {
        Set<String> attrNameSet = this.getColumns().keySet();
        return attrNameSet.toArray(new String[attrNameSet.size()]);
    }

    public Object[] getColumnValues() {
        Collection<Object> attrValueCollection = this.getColumns().values();
        return attrValueCollection.toArray(new Object[attrValueCollection.size()]);
    }

    public Map<String, Object> toMap() {
        return this.getColumns();
    }

    public Row put(Map<String, Object> map) {
        this.getColumns().putAll(map);
        return this;
    }

    public Row put(String key, Object value) {
        this.getColumns().put(key, value);
        return this;
    }

    public int size() {
        return this.columns != null ? this.columns.size() : 0;
    }

    public <T> T toBean(Class<T> beanClass) {
        return DbKit.getConfig().getRecordConvert().toJavaBean(this, beanClass);
    }

    public Kv toKv() {
        return Kv.create().set(this.columns);
    }

    public static Row fromBean(Object bean) {
        return DbKit.getConfig().getRecordConvert().fromJavaBean(bean);
    }

    public static Row by(String column, Object value) {
        Row record = new Row();
        record.getColumns().put(column, value);
        record._getModifyFlag().add(column);
        return record;
    }

    public static Row fromMap(Map<String, Object> recordMap) {
        Row record = new Row();
        return record.setColumns(recordMap);
    }

    public static Row create() {
        return new Row();
    }
}

