/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.crypto;

import com.metaring.framework.Core;
import com.metaring.framework.crypto.DecryptFunctionality;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.util.CryptoUtil;
import java.util.concurrent.CompletableFuture;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

final class DecryptFunctionalityImpl
extends DecryptFunctionality {
    static final String CFG_CRYPTO = "crypto";
    static final String CFG_CRYPTO_ALGORYTHM = "algorythm";
    static final String CFG_CRYPTO_KEY = "key";
    private static final Cipher CIPHER;

    DecryptFunctionalityImpl() {
    }

    @Override
    protected CompletableFuture<Void> preConditionCheck(String input) throws Exception {
        return end;
    }

    @Override
    protected CompletableFuture<String> call(String input) throws Exception {
        if (input == null) {
            return this.end(null);
        }
        return this.end(new String(CIPHER.doFinal(CryptoUtil.BASE_64_DECODER.decode(input))));
    }

    @Override
    protected CompletableFuture<Void> postConditionCheck(String input, String output) throws Exception {
        return end;
    }

    static {
        DataRepresentation crypto = Core.SYSKB.get(CFG_CRYPTO);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(crypto.getText(CFG_CRYPTO_ALGORYTHM));
            byte[] keyBytesFromString = CryptoUtil.BASE_64_DECODER.decode(crypto.getText(CFG_CRYPTO_KEY));
            cipher.init(2, new SecretKeySpec(keyBytesFromString, 0, keyBytesFromString.length, "DES"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        CIPHER = cipher;
    }
}

