/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.crypto;

import com.metaring.framework.Core;
import com.metaring.framework.crypto.EncryptFunctionality;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.util.CryptoUtil;
import java.util.concurrent.CompletableFuture;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

final class EncryptFunctionalityImpl
extends EncryptFunctionality {
    private static final Cipher CIPHER;

    EncryptFunctionalityImpl() {
    }

    @Override
    protected CompletableFuture<Void> preConditionCheck(String input) throws Exception {
        return end;
    }

    @Override
    protected CompletableFuture<String> call(String input) throws Exception {
        if (input == null) {
            return this.end(null);
        }
        return this.end(CryptoUtil.BASE_64_ENCODER.encodeToString(CIPHER.doFinal(input.getBytes())));
    }

    @Override
    protected CompletableFuture<Void> postConditionCheck(String input, String output) throws Exception {
        return end;
    }

    static {
        DataRepresentation crypto = Core.SYSKB.get("crypto");
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(crypto.getText("algorythm"));
            byte[] keyBytesFromString = CryptoUtil.BASE_64_DECODER.decode(crypto.getText("key"));
            cipher.init(1, new SecretKeySpec(keyBytesFromString, 0, keyBytesFromString.length, Core.SYSKB.get("crypto").getText("algorythm")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        CIPHER = cipher;
    }
}

