/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.email;

import com.metaring.framework.SysKB;
import com.metaring.framework.email.EmailHelper;
import com.metaring.framework.email.EmailMessage;
import com.metaring.framework.email.EmailMessageSeries;
import com.metaring.framework.email.EmailTypeEnumerator;
import com.metaring.framework.email.MassiveEmailElement;
import com.metaring.framework.email.MassiveEmailElementSeries;
import com.metaring.framework.email.MassiveLocalizedEmail;
import com.metaring.framework.email.MassiveLocalizedEmailElement;
import com.metaring.framework.email.MassiveLocalizedEmailElementSeries;
import com.metaring.framework.email.SendMassiveLocalizedEmailFunctionality;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

class SendMassiveLocalizedEmailFunctionalityImpl
extends SendMassiveLocalizedEmailFunctionality {
    protected SendMassiveLocalizedEmailFunctionalityImpl(SysKB sysKB) {
        super(sysKB);
    }

    @Override
    protected CompletableFuture<Void> preConditionCheck(MassiveLocalizedEmail massiveLocalizedEmail) throws Exception {
        return end;
    }

    @Override
    protected CompletableFuture<Void> call(MassiveLocalizedEmail massiveLocalizedEmail) throws Exception {
        CompletableFuture<Void> call = new CompletableFuture<Void>();
        CompletableFuture.runAsync(() -> {
            try {
                STGroup templateGroup = EmailHelper.EMAIL_TEMPLATES.get(massiveLocalizedEmail.getLanguage().getTextualValue());
                MassiveLocalizedEmailElementSeries massiveLocalizedEmailElementSeries = massiveLocalizedEmail.getElements();
                ArrayList<EmailMessage> emailMessageList = new ArrayList<EmailMessage>();
                for (int i = 0; i < massiveLocalizedEmailElementSeries.size(); ++i) {
                    MassiveLocalizedEmailElement massiveLocalizedEmailElement = (MassiveLocalizedEmailElement)massiveLocalizedEmailElementSeries.get(i);
                    String templateName = massiveLocalizedEmailElement.getTemplateName();
                    ST subjectTemplate = EmailHelper.getTemplateByName(templateGroup, templateName, "_subject");
                    ST messageTemplate = EmailHelper.getTemplateByName(templateGroup, templateName, "_message");
                    MassiveEmailElementSeries massiveEmailElementSeries = massiveLocalizedEmailElement.getRecipients();
                    for (int j = 0; j < massiveEmailElementSeries.size(); ++j) {
                        MassiveEmailElement massiveEmailElement = (MassiveEmailElement)massiveEmailElementSeries.get(j);
                        String subject = EmailHelper.getFilledByTemplate(templateGroup, subjectTemplate, massiveEmailElement.getArguments());
                        String message = EmailHelper.getFilledByTemplate(templateGroup, messageTemplate, massiveEmailElement.getArguments());
                        EmailMessage emailMessage = EmailMessage.create(EmailHelper.DEFAULT_EMAIL_SENDER, massiveEmailElement.getTos(), massiveEmailElement.getCcs(), massiveEmailElement.getBccs(), subject, EmailTypeEnumerator.HTML, message);
                        emailMessageList.add(emailMessage);
                    }
                }
                EmailMessage[] emailMessages = new EmailMessage[emailMessageList.size()];
                emailMessages = emailMessageList.toArray(emailMessages);
                EmailMessageSeries emailMessageSeries = EmailMessageSeries.create(emailMessages);
                EmailHelper.send(emailMessageSeries);
                call.complete(null);
            }
            catch (Exception e) {
                call.completeExceptionally(e);
            }
        }, EXECUTOR);
        return call;
    }

    @Override
    protected CompletableFuture<Void> postConditionCheck(MassiveLocalizedEmail massiveLocalizedEmail) throws Exception {
        return end;
    }
}

