/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.email;

import com.metaring.framework.CoreType;
import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.email.EmailTemplateArgumentSeries;
import com.metaring.framework.localization.LocaleEnumerator;
import com.metaring.framework.type.DataRepresentation;

public class SingleEmailTemplate
implements GeneratedCoreType {
    public static final String FULLY_QUALIFIED_NAME = "com.metaring.framework.email.singleEmailTemplate";
    private String templateName;
    private LocaleEnumerator language;
    private EmailTemplateArgumentSeries arguments;

    private SingleEmailTemplate(String templateName, LocaleEnumerator language, EmailTemplateArgumentSeries arguments) {
        this.templateName = templateName;
        this.language = language;
        this.arguments = arguments;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public LocaleEnumerator getLanguage() {
        return this.language;
    }

    public EmailTemplateArgumentSeries getArguments() {
        return this.arguments;
    }

    public static SingleEmailTemplate create(String templateName, LocaleEnumerator language, EmailTemplateArgumentSeries arguments) {
        return new SingleEmailTemplate(templateName, language, arguments);
    }

    public static SingleEmailTemplate fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        String templateName = null;
        if (dataRepresentation.hasProperty("templateName").booleanValue()) {
            try {
                templateName = dataRepresentation.getText("templateName");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LocaleEnumerator language = null;
        if (dataRepresentation.hasProperty("language").booleanValue()) {
            try {
                language = (LocaleEnumerator)dataRepresentation.get("language", LocaleEnumerator.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailTemplateArgumentSeries arguments = null;
        if (dataRepresentation.hasProperty("arguments").booleanValue()) {
            try {
                arguments = (EmailTemplateArgumentSeries)dataRepresentation.get("arguments", EmailTemplateArgumentSeries.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SingleEmailTemplate singleEmailTemplate = SingleEmailTemplate.create(templateName, language, arguments);
        return singleEmailTemplate;
    }

    public DataRepresentation toDataRepresentation() {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        if (this.templateName != null) {
            dataRepresentation.add("templateName", this.templateName);
        }
        if (this.language != null) {
            dataRepresentation.add("language", (CoreType)this.language);
        }
        if (this.arguments != null) {
            dataRepresentation.add("arguments", (CoreType[])this.arguments.toArray());
        }
        return dataRepresentation;
    }

    public String toJson() {
        return this.toDataRepresentation().toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

