/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.email;

import com.metaring.framework.Core;
import com.metaring.framework.SysKB;
import com.metaring.framework.controller.AbstractBaseController;
import com.metaring.framework.email.EmailContact;
import com.metaring.framework.email.EmailContactSeries;
import com.metaring.framework.email.EmailController;
import com.metaring.framework.email.EmailMessage;
import com.metaring.framework.email.EmailMessageSeries;
import com.metaring.framework.email.MailExcetpion;
import com.metaring.framework.exception.ManagedException;
import com.metaring.framework.functionality.UnmanagedException;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.type.Email;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

class JavaMailController
extends AbstractBaseController
implements EmailController {
    private Session javaMailSession;
    private static final Long CUSTOM_INFO_LEVEL = 5L;
    private Long actualLevel;
    private boolean test;
    private InternetAddress[] testAddress;

    public JavaMailController() {
        super(Core.SYSKB);
    }

    @Override
    public void send(EmailMessageSeries emailMessageSeries) throws ManagedException, UnmanagedException {
        new Thread(() -> {
            try {
                emailMessageSeries.forEach(this::send);
            }
            catch (Exception e) {
                this.severe(e, new String[0]);
            }
        }).start();
    }

    public void send(EmailMessage emailMessage) {
        new Thread(() -> {
            try {
                this.sendWork(emailMessage);
            }
            catch (Exception e) {
                this.severe(e, new String[0]);
            }
        }).start();
    }

    private final void sendWork(EmailMessage emailMessage) throws ManagedException, UnmanagedException {
        Address fromAddress;
        try {
            fromAddress = this.toJavaMailAddress(emailMessage.getFrom());
        }
        catch (AddressException e) {
            throw new MailExcetpion("Sender address conversion failed", e);
        }
        EmailContactSeries tos = emailMessage.getTos();
        if (tos == null && !this.test && this.testAddress == null) {
            throw new MailExcetpion("No recipient specified");
        }
        Address[] tosArray = null;
        try {
            tosArray = this.toJavaMailAddressArray(tos);
        }
        catch (AddressException e) {
            throw new MailExcetpion("Recipient addresses conversion failed", e);
        }
        EmailContactSeries ccs = emailMessage.getCcs();
        Address[] ccArray = null;
        if (ccs != null) {
            try {
                ccArray = this.toJavaMailAddressArray(ccs);
            }
            catch (AddressException e) {
                throw new MailExcetpion("CC addresses conversion failed", e);
            }
        }
        EmailContactSeries bccs = emailMessage.getBccs();
        Address[] bccArray = null;
        if (bccs != null) {
            try {
                bccArray = this.toJavaMailAddressArray(bccs);
            }
            catch (AddressException e) {
                throw new MailExcetpion("BCC addresses conversion failed", e);
            }
        }
        if (this.testAddress != null) {
            tosArray = this.testAddress;
            ccArray = null;
            bccArray = null;
        }
        try {
            MimeMessage message = new MimeMessage(this.javaMailSession);
            message.setSubject(emailMessage.getSubject());
            message.setRecipients(Message.RecipientType.TO, tosArray);
            if (ccArray != null) {
                message.setRecipients(Message.RecipientType.CC, ccArray);
            }
            if (bccArray != null) {
                message.setRecipients(Message.RecipientType.BCC, bccArray);
            }
            message.setFrom(fromAddress);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setHeader("Content-Type", emailMessage.getType().getTextualValue());
            messageBodyPart.setContent((Object)emailMessage.getMessage(), emailMessage.getType().getTextualValue());
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            if (!this.test) {
                try {
                    Transport.send((Message)message);
                }
                catch (MessagingException ex) {
                    this.severe(ex, new String[0]);
                }
            }
        }
        catch (Exception e) {
            throw new MailExcetpion("Mail initialization failed", e);
        }
    }

    protected void info(String description, Address[] ... addresses) {
        if (this.actualLevel == null) {
            this.actualLevel = this.getLogger().getActualStackPosition();
        }
        ArrayList<String> messagesList = new ArrayList<String>();
        for (Object[] objectArray : addresses) {
            if (objectArray == null) continue;
            messagesList.add(Arrays.toString(objectArray));
        }
        String[] messages = new String[messagesList.size()];
        messages = messagesList.toArray(messages);
        this.getLogger().setActualStackPosition(CUSTOM_INFO_LEVEL);
        super.info(description, messages);
        this.getLogger().setActualStackPosition(this.actualLevel);
    }

    protected Address toJavaMailAddress(EmailContact emailContact) throws AddressException {
        InternetAddress address = null;
        if (emailContact != null) {
            String name = "";
            if (emailContact.getName() != null) {
                name = name + emailContact.getName();
            }
            if (emailContact.getSurname() != null) {
                name = name + " " + emailContact.getSurname();
            }
            name = name.trim();
            String mail = null;
            try {
                mail = emailContact.getMail().toJson().replace("\"", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                address = new InternetAddress(mail, name);
            }
            catch (UnsupportedEncodingException e) {
                throw new AddressException(e.getMessage());
            }
        }
        return address;
    }

    protected Address toJavaMailAddress(Email email) throws AddressException {
        InternetAddress address = null;
        if (email != null) {
            String mail = null;
            try {
                mail = email.toJson().replace("\"", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            address = new InternetAddress(mail);
        }
        return address;
    }

    protected Address[] toJavaMailAddressArray(EmailContactSeries emailContactSeries) throws AddressException {
        ArrayList<Address> list = new ArrayList<Address>();
        int i = 0;
        while ((long)i < (long)emailContactSeries.size()) {
            EmailContact emailContact = (EmailContact)emailContactSeries.get(i);
            Address address = this.toJavaMailAddress(emailContact);
            list.add(address);
            ++i;
        }
        Address[] addressArray = new Address[list.size()];
        return list.toArray(addressArray);
    }

    @Override
    public void reinit(SysKB sysKB) {
        this.test = false;
        this.testAddress = null;
        if (!sysKB.hasProperty("email").booleanValue()) {
            return;
        }
        DataRepresentation emailConfiguration = sysKB.get("email");
        if (emailConfiguration.hasProperty("test").booleanValue()) {
            try {
                this.test = emailConfiguration.getTruth("test");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (emailConfiguration.hasProperty("testAddress").booleanValue()) {
            try {
                this.testAddress = new InternetAddress[]{new InternetAddress(emailConfiguration.getText("testAddress"))};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Properties properties = new Properties();
        try {
            for (String propertyName : emailConfiguration.getProperties()) {
                properties.setProperty(propertyName, emailConfiguration.getText(propertyName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        final String mailSmtpUser = properties.getProperty("mail.smtp.user");
        final String mailSmtpPassword = properties.getProperty("mail.smtp.password");
        this.javaMailSession = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(mailSmtpUser, mailSmtpPassword);
            }
        });
    }
}

