/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.email;

import com.metaring.framework.CoreType;
import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.localization.LocaleEnumerator;
import com.metaring.framework.type.DataRepresentation;

public class EmailContentFromTemplate
implements GeneratedCoreType {
    public static final String FULLY_QUALIFIED_NAME = "com.metaring.framework.email.emailContentFromTemplate";
    private String subject;
    private String message;
    private LocaleEnumerator language;

    private EmailContentFromTemplate(String subject, String message, LocaleEnumerator language) {
        this.subject = subject;
        this.message = message;
        this.language = language;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public LocaleEnumerator getLanguage() {
        return this.language;
    }

    public static EmailContentFromTemplate create(String subject, String message, LocaleEnumerator language) {
        return new EmailContentFromTemplate(subject, message, language);
    }

    public static EmailContentFromTemplate fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        String subject = null;
        if (dataRepresentation.hasProperty("subject").booleanValue()) {
            try {
                subject = dataRepresentation.getText("subject");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String message = null;
        if (dataRepresentation.hasProperty("message").booleanValue()) {
            try {
                message = dataRepresentation.getText("message");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LocaleEnumerator language = null;
        if (dataRepresentation.hasProperty("language").booleanValue()) {
            try {
                language = (LocaleEnumerator)dataRepresentation.get("language", LocaleEnumerator.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EmailContentFromTemplate emailContentFromTemplate = EmailContentFromTemplate.create(subject, message, language);
        return emailContentFromTemplate;
    }

    public DataRepresentation toDataRepresentation() {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        if (this.subject != null) {
            dataRepresentation.add("subject", this.subject);
        }
        if (this.message != null) {
            dataRepresentation.add("message", this.message);
        }
        if (this.language != null) {
            dataRepresentation.add("language", (CoreType)this.language);
        }
        return dataRepresentation;
    }

    public String toJson() {
        return this.toDataRepresentation().toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

