/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.email;

import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.email.EmailTypeEnumeratorSeries;
import com.metaring.framework.type.DataRepresentation;

public class EmailTypeEnumerator
implements GeneratedCoreType {
    public static final EmailTypeEnumerator TEXT = new EmailTypeEnumerator("TEXT", 0L, "text/plain");
    public static final EmailTypeEnumerator HTML = new EmailTypeEnumerator("HTML", 1L, "text/html");
    private String name;
    private Long numericValue;
    private String textualValue;

    private EmailTypeEnumerator(String name, Long numericValue, String textualValue) {
        this.name = name;
        this.numericValue = numericValue;
        this.textualValue = textualValue;
    }

    public String getName() {
        return this.name;
    }

    public Long getNumericValue() {
        return this.numericValue;
    }

    public String getTextualValue() {
        return this.textualValue;
    }

    public static final EmailTypeEnumeratorSeries listAll() {
        return EmailTypeEnumeratorSeries.create(TEXT, HTML);
    }

    public static EmailTypeEnumerator getByNumericValue(Long numericValue) {
        if (numericValue == null) {
            return null;
        }
        switch (numericValue.intValue()) {
            case 0: {
                return TEXT;
            }
            case 1: {
                return HTML;
            }
        }
        return null;
    }

    public static EmailTypeEnumerator getByTextualValue(String textualValue) {
        if (textualValue == null) {
            return null;
        }
        switch (textualValue) {
            case "text/plain": {
                return TEXT;
            }
            case "text/html": {
                return HTML;
            }
        }
        return null;
    }

    public static EmailTypeEnumerator getByName(String emailTypeEnumeratorName) {
        if (emailTypeEnumeratorName == null) {
            return null;
        }
        switch (emailTypeEnumeratorName) {
            case "TEXT": {
                return TEXT;
            }
            case "HTML": {
                return HTML;
            }
        }
        return null;
    }

    public static EmailTypeEnumerator fromJson(String json) {
        if (json == null) {
            return null;
        }
        if (json.startsWith("\"")) {
            json = json.substring(1);
        }
        if (json.endsWith("\"")) {
            json = json.substring(0, json.length() - 1);
        }
        try {
            return EmailTypeEnumerator.getByNumericValue(Long.parseLong(json));
        }
        catch (Exception exception) {
            EmailTypeEnumerator result = EmailTypeEnumerator.getByTextualValue(json);
            return result != null ? result : EmailTypeEnumerator.getByName(json);
        }
    }

    public String toJson() {
        return "\"" + this.name + "\"";
    }

    public DataRepresentation toDataRepresentation() {
        return Tools.FACTORY_DATA_REPRESENTATION.fromJson(this.toJson());
    }

    public String toString() {
        return this.toJson();
    }
}

