/**
 * Copyright 2019 MetaRing s.r.l.
 * 
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.metaring.generator.server_java.factories;

import com.metaring.generator.model.data.Data;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class DataFactory implements com.metaring.generator.model.factories.DataFactory {
  @Override
  public String getFilename(final Data data) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�data.packagePath�/�IF data.incomplete�Abstract�ENDIF��data.name.toFirstUpper�.java");
    return _builder.toString();
  }
  
  @Override
  public String getManyFilename(final Data data) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�data.packagePath�/�data.name.toFirstUpper�Series.java");
    return _builder.toString();
  }
  
  @Override
  public String getContent(final Data data) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�data.generatedPackageDeclaration�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�val dataClassName = data.name.toFirstUpper�");
    _builder.newLine();
    _builder.append("�val dataFQN = data.nativeFullyQualifiedName�");
    _builder.newLine();
    _builder.append("�val dataAttributeTypes = data.attributes.map[it.type]�");
    _builder.newLine();
    _builder.append("�val dataAttributeNames = data.attributes.map[it.valueName]�");
    _builder.newLine();
    _builder.append("�FOR attributeFQN : data.attributes.filter[attribute | !attribute.unknown].map[it.nativeFullyQualifiedNameForImport].filter[it !== null && it != dataFQN].toSet�");
    _builder.newLine();
    _builder.append("import �attributeFQN�;");
    _builder.newLine();
    _builder.append("�ENDFOR�");
    _builder.newLine();
    _builder.append("import �\"Tools\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"type.DataRepresentation\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"GeneratedCoreType\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�IF !data.internal�public �ENDIF��IF data.incomplete�abstract �ENDIF�class �IF data.incomplete�Abstract�ENDIF��dataClassName� implements GeneratedCoreType {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static final String FULLY_QUALIFIED_NAME = \"�data.fullyQualifiedName�\";");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�var fields = \"\"�");
    _builder.newLine();
    _builder.append("�for(var i = 0; i < dataAttributeTypes.size; i++) {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=\"    private \" + dataAttributeTypes.get(i) + \" \" + dataAttributeNames.get(i) + \";\\n\"");
    _builder.newLine();
    _builder.append("}�");
    _builder.newLine();
    _builder.append("�fields�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�fields = \"\"�");
    _builder.newLine();
    _builder.append("�for(var i = 0; i < dataAttributeTypes.size; i++) {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=dataAttributeTypes.get(i) + \" \" + dataAttributeNames.get(i)");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("if(i < dataAttributeTypes.size -1) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("fields+=\", \"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}�");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("�IF data.incomplete�protected�ELSE�private�ENDIF� �IF data.incomplete�Abstract�ENDIF��dataClassName�(�fields�) {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("�fields = \"\"�");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("�for(var i = 0; i < dataAttributeTypes.size; i++) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("fields+=\"    this.\" + dataAttributeNames.get(i) + \" = \" + dataAttributeNames.get(i) + \";\\n\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}�");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("�fields�");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("�fields = \"\"�");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("�for(var i = 0; i < dataAttributeTypes.size; i++) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("fields+=\"    public \" + dataAttributeTypes.get(i) + \" get\" + dataAttributeNames.get(i).toFirstUpper + \"() {\\n\"");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("fields+=\"        return this.\" + dataAttributeNames.get(i) + \";\\n    }\\n\\n\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}�");
    _builder.newLine();
    _builder.append("�fields�");
    _builder.newLine();
    _builder.append("�fields = \"\"�");
    _builder.newLine();
    _builder.append("�for(var i = 0; i < dataAttributeTypes.size; i++) {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=dataAttributeTypes.get(i) + \" \" + dataAttributeNames.get(i)");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("if(i < dataAttributeTypes.size -1) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("fields+=\", \"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}�");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �dataClassName� create(�fields�) {");
    _builder.newLine();
    _builder.append("�fields = \"\"�");
    _builder.newLine();
    _builder.append("�for(var i = 0; i < dataAttributeTypes.size; i++) {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=dataAttributeNames.get(i)");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("if(i < dataAttributeTypes.size -1) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("fields+=\", \"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}�");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return new �dataClassName�(�fields�);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �dataClassName� fromJson(String jsonString) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(jsonString == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("        ");
    _builder.append("jsonString = jsonString.trim();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(jsonString.isEmpty()) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(jsonString.equalsIgnoreCase(\"null\")) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("        ");
    _builder.append("DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�fields = \"\"�");
    _builder.newLine();
    _builder.append("�for(var i = 0; i < dataAttributeTypes.size; i++) {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("var fieldName = dataAttributeNames.get(i)");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+= \"        \" + dataAttributeTypes.get(i) + \" \" + fieldName + \" = null;\\n\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+= \"        if(dataRepresentation.hasProperty(\\\"\" + fieldName + \"\\\")) {\\n\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+= \"            try {\\n\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+= \"                \" + fieldName + \" = \"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=data.attributes.get(i).getDataOrNativeTypeFromJsonCreatorMethod(fieldName);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=\";\\n            } catch (Exception e) {\\n            }\\n        }\\n\\n\"");
    _builder.newLine();
    _builder.append("}�");
    _builder.newLine();
    _builder.append("�fields�");
    _builder.newLine();
    _builder.append("�fields = \"\"�");
    _builder.newLine();
    _builder.append("�for(var i = 0; i < dataAttributeTypes.size; i++) {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=dataAttributeNames.get(i)");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("if(i < dataAttributeTypes.size -1) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("fields+=\", \"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}�");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("�dataClassName� �dataClassName.toFirstLower� = create(�fields�);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return �dataClassName.toFirstLower�;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �dataClassName� fromObject(Object object) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(object == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("        ");
    _builder.append("DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromObject(object);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�fields = \"\"�");
    _builder.newLine();
    _builder.append("�for(var i = 0; i < dataAttributeTypes.size; i++) {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("var fieldName = dataAttributeNames.get(i)");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+= \"        \" + dataAttributeTypes.get(i) + \" \" + fieldName + \" = null;\\n\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+= \"        if(dataRepresentation.hasProperty(\\\"\" + fieldName + \"\\\")) {\\n\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+= \"            try {\\n\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+= \"                \" + fieldName + \" = \"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=data.attributes.get(i).getDataOrNativeTypeFromJsonCreatorMethod(fieldName);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=\";\\n            } catch (Exception e) {\\n            }\\n        }\\n\\n\"");
    _builder.newLine();
    _builder.append("}�");
    _builder.newLine();
    _builder.append("�fields�");
    _builder.newLine();
    _builder.append("�fields = \"\"�");
    _builder.newLine();
    _builder.append("�for(var i = 0; i < dataAttributeTypes.size; i++) {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=dataAttributeNames.get(i)");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("if(i < dataAttributeTypes.size -1) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("fields+=\", \"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}�");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("�dataClassName� �dataClassName.toFirstLower� = create(�fields�);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return �dataClassName.toFirstLower�;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public DataRepresentation toDataRepresentation() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();");
    _builder.newLine();
    _builder.append("�fields = \"\"�");
    _builder.newLine();
    _builder.append("�for(var i = 0; i < dataAttributeTypes.size; i++) {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("var fieldName = dataAttributeNames.get(i)");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("var fieldAttributeType = data.attributes.get(i)");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=\"        if (\" + fieldName + \" != null) {\\n\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=\"            dataRepresentation.add(\\\"\" + fieldName + \"\\\", \" + fieldName");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("if(!fieldAttributeType.unknown && fieldAttributeType.many) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("fields += \".toArray()\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=\");\\n\"");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("fields+=\"        }\\n\\n\"");
    _builder.newLine();
    _builder.append("}�");
    _builder.newLine();
    _builder.append("�fields�");
    _builder.newLine();
    _builder.append("�fields = \"\"�");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return dataRepresentation;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public String toJson() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return toDataRepresentation().toJson();");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public String toString() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return this.toJson();");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
  
  @Override
  public String getManyContent(final Data data) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�data.generatedPackageDeclaration�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�val dataClassName = data.name.toFirstUpper�");
    _builder.newLine();
    _builder.append("�val datas = dataClassName.toFirstLower.plural�");
    _builder.newLine();
    _builder.append("import java.util.List;");
    _builder.newLine();
    _builder.append("import java.util.ArrayList;");
    _builder.newLine();
    _builder.append("import java.util.Arrays;");
    _builder.newLine();
    _builder.append("import java.util.Collection;");
    _builder.newLine();
    _builder.append("import java.util.function.Predicate;");
    _builder.newLine();
    _builder.append("import java.util.function.UnaryOperator;");
    _builder.newLine();
    _builder.append("import java.util.stream.Collectors;");
    _builder.newLine();
    _builder.append("import java.util.stream.StreamSupport;");
    _builder.newLine();
    _builder.append("import org.apache.calcite.linq4j.Enumerable;");
    _builder.newLine();
    _builder.append("import org.apache.calcite.linq4j.Linq4j;");
    _builder.newLine();
    _builder.append("import �\"Tools\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"type.DataRepresentation\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"GeneratedCoreType\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�IF !data.internal�public �ENDIF�class �dataClassName�Series extends ArrayList<�dataClassName�> implements GeneratedCoreType {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private static final long serialVersionUID = 1L;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private Enumerable<�dataClassName�> internalEnumerable;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private �dataClassName�Series(Iterable<�dataClassName�> iterable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("super();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("this.addAll(StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList()));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �dataClassName�Series create(Iterable<�dataClassName�> iterable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return new �dataClassName�Series(iterable);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �dataClassName�Series create(�dataClassName�... �datas�) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return create(�datas� == null ? new ArrayList<>() : Arrays.asList(�datas�));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public �dataClassName�[] toArray() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return this.toArray(new �dataClassName�[this.size()]);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public Enumerable<�dataClassName�> asEnumerable() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return internalEnumerable != null ? internalEnumerable : (internalEnumerable = Linq4j.asEnumerable(this));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean addAll(Enumerable<�dataClassName�> enumerable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return enumerable == null ? false : this.addAll(enumerable.toList());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean containsAll(Enumerable<�dataClassName�> enumerable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return enumerable == null ? false : this.containsAll(enumerable.toList());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean removeAll(Enumerable<�dataClassName�> enumerable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return enumerable == null ? false : this.removeAll(enumerable.toList());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean retainAll(Enumerable<�dataClassName�> enumerable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return enumerable == null ? false : this.retainAll(enumerable.toList());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean addAll(�dataClassName�[] array) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return array == null ? false : this.addAll(Arrays.asList(array));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean containsAll(�dataClassName�[] array) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return array == null ? false : this.containsAll(Arrays.asList(array));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean removeAll(�dataClassName�[] array) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return array == null ? false : this.removeAll(Arrays.asList(array));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean retainAll(�dataClassName�[] array) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return array == null ? false : this.retainAll(Arrays.asList(array));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private void recreateEnumerable() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if (internalEnumerable != null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("internalEnumerable = Linq4j.asEnumerable(this);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean add(�dataClassName� e) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.add(e);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public void add(int index, �dataClassName� element) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("super.add(index, element);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean addAll(Collection<? extends �dataClassName�> c) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.addAll(c);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean addAll(int index, Collection<? extends �dataClassName�> c) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.addAll(index, c);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean remove(Object o) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.remove(o);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public �dataClassName� remove(int index) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("�dataClassName� test = super.remove(index);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean removeAll(Collection<?> c) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.removeAll(c);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean removeIf(Predicate<? super �dataClassName�> filter) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.removeIf(filter);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean retainAll(Collection<?> c) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.retainAll(c);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public void replaceAll(UnaryOperator<�dataClassName�> operator) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("super.replaceAll(operator);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �dataClassName�Series fromJson(String jsonString) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if (jsonString == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("jsonString = jsonString.trim();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(jsonString.isEmpty()) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(jsonString.equalsIgnoreCase(\"null\")) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("        ");
    _builder.append("DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("List<�dataClassName�> list = new ArrayList<>();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("for(DataRepresentation data : dataRepresentation) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("list.add(�dataClassName�.fromJson(data.asText()));");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return new �dataClassName�Series(list);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �dataClassName�Series fromObject(Object object) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if (object == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("        ");
    _builder.append("DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromObject(object);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("List<�dataClassName�> list = new ArrayList<>();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("for(DataRepresentation data : dataRepresentation) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("list.add(�dataClassName�.fromJson(data.asText()));");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return new �dataClassName�Series(list);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public DataRepresentation toDataRepresentation() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return Tools.FACTORY_DATA_REPRESENTATION.fromJson(toJson());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public String toJson() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("StringBuilder sb = new StringBuilder(\"[\");");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(!isEmpty()) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("forEach(it -> sb.append(it.toJson()).append(\",\"));");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("sb.delete(sb.length() - 1, sb.length());");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return sb.append(\"]\").toString();");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public String toString() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return toJson();");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
}
