/**
 * Copyright 2019 MetaRing s.r.l.
 * 
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.metaring.generator.server_java.factories;

import com.metaring.generator.model.data.Enumerator;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class EnumeratorFactory implements com.metaring.generator.model.factories.EnumeratorFactory {
  @Override
  public String getFilename(final Enumerator enumerator) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�enumerator.packagePath�/�enumerator.name.toFirstUpper�Enumerator.java");
    return _builder.toString();
  }
  
  @Override
  public String getManyFilename(final Enumerator enumerator) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�enumerator.packagePath�/�enumerator.name.toFirstUpper�EnumeratorSeries.java");
    return _builder.toString();
  }
  
  @Override
  public String getContent(final Enumerator enumerator) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�enumerator.generatedPackageDeclaration�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�val enumeratorClassName = enumerator.name.toFirstUpper + \"Enumerator\"�");
    _builder.newLine();
    _builder.append("import �\"Tools\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"type.DataRepresentation\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"GeneratedCoreType\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�IF !enumerator.internal�public �ENDIF�class �enumeratorClassName� implements GeneratedCoreType {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("�FOR value : enumerator.values�");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static final �enumeratorClassName� �value.name.toStaticFieldName� = new �enumeratorClassName�(\"�value.name.toStaticFieldName�\", �value.numericValue�l, \"�value.textualValue�\");");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("�ENDFOR�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private String name;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private Long numericValue;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private String textualValue;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private �enumeratorClassName�(String name, Long numericValue, String textualValue) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("this.name = name;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("this.numericValue = numericValue;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("this.textualValue = textualValue;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public String getName() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return this.name;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public Long getNumericValue() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return this.numericValue;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public String getTextualValue() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return this.textualValue;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static final �enumeratorClassName�Series listAll() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return �enumeratorClassName�Series.create(�FOR value : enumerator.values SEPARATOR \', \'��value.name.toStaticFieldName��ENDFOR�);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �enumeratorClassName� getByNumericValue(Long numericValue) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(numericValue == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("switch(numericValue.intValue()) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("�FOR value : enumerator.values�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("            ");
    _builder.append("case �value.numericValue� : return �value.name.toStaticFieldName�;");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("�ENDFOR�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("            ");
    _builder.append("default: return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �enumeratorClassName� getByTextualValue(String textualValue) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(textualValue == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("switch(textualValue) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("�FOR value : enumerator.values�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("            ");
    _builder.append("case \"�value.textualValue�\" : return �value.name.toStaticFieldName�;");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("�ENDFOR�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("            ");
    _builder.append("default: return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�var enumeratorName = enumeratorClassName.toFirstLower + \"Name\"�");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �enumeratorClassName� getByName(String �enumeratorName�) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(�enumeratorName� == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("switch(�enumeratorName�) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("�FOR value : enumerator.values�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("            ");
    _builder.append("case \"�value.name�\" : return �value.name.toStaticFieldName�;");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("�ENDFOR�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("            ");
    _builder.append("default: return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �enumeratorClassName� fromJson(String json) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(json == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(json.startsWith(\"\\\"\")) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("json = json.substring(1);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(json.endsWith(\"\\\"\")) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("json = json.substring(0, json.length() - 1);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return getByNumericValue(Long.parseLong(json));");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("} catch(Exception e) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("�enumeratorClassName� result = getByTextualValue(json);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return result != null ? result : getByName(json);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public String toJson() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return \"\\\"\" + this.name + \"\\\"\";");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public DataRepresentation toDataRepresentation() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return Tools.FACTORY_DATA_REPRESENTATION.fromJson(toJson());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public String toString() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return toJson();");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
  
  @Override
  public String getManyContent(final Enumerator enumerator) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�enumerator.generatedPackageDeclaration�");
    _builder.newLine();
    _builder.append("�var enumeratorClassName = enumerator.name.toFirstUpper + \"Enumerator\"�");
    _builder.newLine();
    _builder.append("�var enumerators = enumerator.name.plural�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import java.util.ArrayList;");
    _builder.newLine();
    _builder.append("import java.util.Arrays;");
    _builder.newLine();
    _builder.append("import java.util.Collection;");
    _builder.newLine();
    _builder.append("import java.util.function.Predicate;");
    _builder.newLine();
    _builder.append("import java.util.function.UnaryOperator;");
    _builder.newLine();
    _builder.append("import java.util.stream.Collectors;");
    _builder.newLine();
    _builder.append("import java.util.stream.StreamSupport;");
    _builder.newLine();
    _builder.append("import org.apache.calcite.linq4j.Enumerable;");
    _builder.newLine();
    _builder.append("import org.apache.calcite.linq4j.Linq4j;");
    _builder.newLine();
    _builder.append("import �\"GeneratedCoreType\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"Tools\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"type.DataRepresentation\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�IF !enumerator.internal�public �ENDIF�class �enumeratorClassName�Series extends ArrayList<�enumeratorClassName�> implements GeneratedCoreType {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private static final long serialVersionUID = 1L;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private Enumerable<�enumeratorClassName�> internalEnumerable;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private �enumeratorClassName�Series(Iterable<�enumeratorClassName�> iterable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("super();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("this.addAll(StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList()));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �enumeratorClassName�Series create(Iterable<�enumeratorClassName�> iterable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return new �enumeratorClassName�Series(iterable);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �enumeratorClassName�Series create(�enumeratorClassName�... �enumerators�) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return create(�enumerators� == null ? new ArrayList<>() : Arrays.asList(�enumerators�));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public �enumeratorClassName�[] toArray() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return this.toArray(new �enumeratorClassName�[this.size()]);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public Enumerable<�enumeratorClassName�> asEnumerable() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return internalEnumerable != null ? internalEnumerable : (internalEnumerable = Linq4j.asEnumerable(this));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean addAll(Enumerable<�enumeratorClassName�> enumerable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return enumerable == null ? false : this.addAll(enumerable.toList());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean containsAll(Enumerable<�enumeratorClassName�> enumerable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return enumerable == null ? false : this.containsAll(enumerable.toList());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean removeAll(Enumerable<�enumeratorClassName�> enumerable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return enumerable == null ? false : this.removeAll(enumerable.toList());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean retainAll(Enumerable<�enumeratorClassName�> enumerable) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return enumerable == null ? false : this.retainAll(enumerable.toList());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean addAll(�enumeratorClassName�[] array) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return array == null ? false : this.addAll(Arrays.asList(array));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean containsAll(�enumeratorClassName�[] array) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return array == null ? false : this.containsAll(Arrays.asList(array));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean removeAll(�enumeratorClassName�[] array) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return array == null ? false : this.removeAll(Arrays.asList(array));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean retainAll(�enumeratorClassName�[] array) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return array == null ? false : this.retainAll(Arrays.asList(array));");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private void recreateEnumerable() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if (internalEnumerable != null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("internalEnumerable = Linq4j.asEnumerable(this);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean add(�enumeratorClassName� e) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.add(e);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public void add(int index, �enumeratorClassName� element) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("super.add(index, element);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean addAll(Collection<? extends �enumeratorClassName�> c) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.addAll(c);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean addAll(int index, Collection<? extends �enumeratorClassName�> c) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.addAll(index, c);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean remove(Object o) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.remove(o);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public �enumeratorClassName� remove(int index) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("�enumeratorClassName� test = super.remove(index);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean removeAll(Collection<?> c) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.removeAll(c);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean removeIf(Predicate<? super �enumeratorClassName�> filter) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.removeIf(filter);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public boolean retainAll(Collection<?> c) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("boolean test = super.retainAll(c);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return test;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public void replaceAll(UnaryOperator<�enumeratorClassName�> operator) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("super.replaceAll(operator);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("recreateEnumerable();");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static �enumeratorClassName�Series fromJson(String jsonString) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if (jsonString == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("jsonString = jsonString.trim();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(jsonString.isEmpty()) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(jsonString.equalsIgnoreCase(\"null\")) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("        ");
    _builder.append("DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("�enumeratorClassName�[] values = new �enumeratorClassName�[dataRepresentation.length()];");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("for(int i = 0; i < values.length; i++) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("values[i] = dataRepresentation.get(i, �enumeratorClassName�.class);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return create(values);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public String toString() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return toJson();");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public String toJson() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("StringBuilder sb = new StringBuilder(\"[\");");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(!isEmpty()) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("forEach(it -> sb.append(it.toJson()).append(\",\"));");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("sb.delete(sb.length() - 1, sb.length());");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return sb.append(\"]\").toString();");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public DataRepresentation toDataRepresentation() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return Tools.FACTORY_DATA_REPRESENTATION.fromJson(toJson());");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
}
