/**
 * Copyright 2019 MetaRing s.r.l.
 * 
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.metaring.generator.server_java.factories;

import com.metaring.generator.model.data.Attribute;
import com.metaring.generator.model.data.Functionality;
import com.metaring.generator.util.java.Extensions;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class FunctionalityFactory implements com.metaring.generator.model.factories.FunctionalityFactory {
  @Override
  public String getFilename(final Functionality functionality) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�functionality.packagePath�/�functionality.name.toFirstUpper�Functionality.java");
    return _builder.toString();
  }
  
  @Override
  public String getContent(final Functionality functionality) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�functionality.generatedPackageDeclaration�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import java.util.concurrent.CompletableFuture;");
    _builder.newLine();
    _builder.append("�IF functionality.shouldImportTools�");
    _builder.newLine();
    _builder.append("import �\"Tools\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("�ENDIF�");
    _builder.newLine();
    _builder.append("import �\"functionality.AbstractFunctionality\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"functionality.GeneratedFunctionality\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"functionality.FunctionalityInfo\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("�val functionalityClassName = functionality.name.toFirstUpper + \"Functionality\"�");
    _builder.newLine();
    _builder.append("�var String inputPackage=null�");
    _builder.newLine();
    _builder.append("�var String input=null�");
    _builder.newLine();
    _builder.append("�IF functionality.input !== null�");
    _builder.newLine();
    _builder.append("�IF (inputPackage = functionality.input.nativeFullyQualifiedNameForImport) !== null�");
    _builder.newLine();
    _builder.append("import �inputPackage�;");
    _builder.newLine();
    _builder.append("�ENDIF�");
    _builder.newLine();
    _builder.append("�ENDIF�");
    _builder.newLine();
    _builder.append("�var String outputPackage=null�");
    _builder.newLine();
    _builder.append("�var String output=null�");
    _builder.newLine();
    _builder.append("�IF functionality.output !== null�");
    _builder.newLine();
    _builder.append("�IF (outputPackage = functionality.output.nativeFullyQualifiedNameForImport) !== null && outputPackage != inputPackage�");
    _builder.newLine();
    _builder.append("import �outputPackage�;");
    _builder.newLine();
    _builder.append("�ENDIF�");
    _builder.newLine();
    _builder.append("�ENDIF�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("abstract class �functionalityClassName� extends AbstractFunctionality implements GeneratedFunctionality {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("static final FunctionalityInfo INFO = FunctionalityInfo.create(\"�functionality.fullyQualifiedName�\", �IF functionality.internal�true�ELSE�false�ENDIF�, �IF functionality.reserved�true�ELSE�false�ENDIF�, �IF functionality.restricted�true�ELSE�false�ENDIF�, �IF functionality.input !== null�\"�functionality.input.nativeFullyQualifiedName�\"�ELSE�null�ENDIF�, �IF functionality.output !== null�\"�functionality.output.nativeFullyQualifiedName�\"�ELSE�null�ENDIF�);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("static final �functionalityClassName� INSTANCE = new �functionalityClassName�Impl();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected �functionalityClassName�() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("super(INFO, �IF functionality.output !== null��output = functionality.output.type�.class�ELSE�null�ENDIF�);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> beforePreConditionCheck(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("CompletableFuture<Void> response = beforePreConditionCheck(�IF functionality.input !== null�input == null ? null : (�input = functionality.input.type�) input�ENDIF�);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return response == null ? end : response;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> beforePreConditionCheck(�IF input!==null��input� input�ENDIF�) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return end;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> preConditionCheck(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("CompletableFuture<Void> response = preConditionCheck(�IF input !== null�input == null ? null : (�input�) input�ENDIF�);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return response == null ? end : response;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected abstract CompletableFuture<Void> preConditionCheck(�IF input!==null��input� input�ENDIF�) throws Exception;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> afterPreConditionCheck(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("CompletableFuture<Void> response = afterPreConditionCheck(�IF input !== null�input == null ? null : (�input�) input�ENDIF�);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return response == null ? end : response;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> afterPreConditionCheck(�IF input!==null��input� input�ENDIF�) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return end;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> beforeCall(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("CompletableFuture<Void> response = beforeCall(�IF input !== null�input == null ? null : (�input�) input�ENDIF�);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return response == null ? end : response;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> beforeCall(�IF input!==null��input� input�ENDIF�) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return end;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Object> call(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("CompletableFuture<�IF output === null�Void�ELSE��output��ENDIF�> call = call(�IF input !==null�(�input�) input�ENDIF�);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(call == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return end(null);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("final CompletableFuture<Object> response = new CompletableFuture<>();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("call.whenCompleteAsync((result, error) -> {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("if(error != null) {");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("response.completeExceptionally(error);");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("response.complete(result);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}, EXECUTOR);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return response;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected abstract CompletableFuture<�IF output === null�Void�ELSE��output��ENDIF�> call(�IF input !==null��input� input�ENDIF�) throws Exception;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> afterCall(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("CompletableFuture<Void> response = afterCall(�IF input !== null�input == null ? null : (�input�) input�IF output !== null�, �ENDIF��ENDIF��IF output !== null�output == null ? null : (�output�) output�ENDIF�);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return response == null ? end : response;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> afterCall(�IF input!==null��input� input�IF output !== null�, �ENDIF��ENDIF��IF output!==null��output� output�ENDIF�) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return end;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> beforePostConditionCheck(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("CompletableFuture<Void> response = beforePostConditionCheck(�IF input !== null�input == null ? null : (�input�) input�IF output !== null�, �ENDIF��ENDIF��IF output !== null�output == null ? null : (�output�) output�ENDIF�);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return response == null ? end : response;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> beforePostConditionCheck(�IF input!==null��input� input�IF output !== null�, �ENDIF��ENDIF��IF output!==null��output� output�ENDIF�) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return end;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> postConditionCheck(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("CompletableFuture<Void> response = postConditionCheck(�IF input !== null�input == null ? null : (�input�) input�IF output !== null�, �ENDIF��ENDIF��IF output !== null�output == null ? null : (�output�) output�ENDIF�);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return response == null ? end : response;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected abstract CompletableFuture<Void> postConditionCheck(�IF input !== null��input� input�IF output !== null�, �ENDIF��ENDIF��IF output !== null��output� output�ENDIF�) throws Exception;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> afterPostConditionCheck(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("CompletableFuture<Void> response = afterPostConditionCheck(�IF input !== null�input == null ? null : (�input�) input�IF output !== null�, �ENDIF��ENDIF��IF output !== null�output == null ? null : (�output�) output�ENDIF�);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return response == null ? end : response;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> afterPostConditionCheck(�IF input !== null��input� input�IF output !== null�, �ENDIF��ENDIF��IF output!==null��output� output�ENDIF�) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return end;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("�IF input !== null�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final Object getInputFromJsonWork(String inputJson) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return �functionality.input.getDataOrNativeTypeFromJsonCreatorMethodForFunctionality(\"inputJson\")�;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("�ENDIF�");
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
  
  @Override
  public String getModuleFunctionalitiesManagerFilename(final com.metaring.generator.model.data.Module module, final List<Functionality> functionalities) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.packagePath�/�module.dotAwareName.toFirstUpper�FunctionalitiesManager.java");
    return _builder.toString();
  }
  
  @Override
  public String getModuleFunctionalitiesManagerContent(final com.metaring.generator.model.data.Module module, final List<Functionality> functionalities) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.generatedPackageDeclaration�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import �\"functionality.FunctionalityInfo\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"functionality.FunctionalitiesManager\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"functionality.GeneratedFunctionalitiesManager\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"functionality.Functionality\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import java.util.concurrent.CompletableFuture;");
    _builder.newLine();
    _builder.append("�FOR importation : functionalities.getImportsForManager�");
    _builder.newLine();
    _builder.append("�IF !importation.equalsIgnoreCase(\"functionality.FunctionalityExecutionResult\".combineWithSystemNamespace)�import �importation�;�ENDIF�");
    _builder.newLine();
    _builder.append("�ENDFOR�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class �module.dotAwareName.toFirstUpper�FunctionalitiesManager extends FunctionalitiesManager implements GeneratedFunctionalitiesManager {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�functionalities.generateFunctionalitiesInfoForManager�");
    _builder.newLine();
    _builder.append("�functionalities.generateFunctionalitiesCallsForManager�");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
  
  public static List<String> getImportsForManager(final List<Functionality> functionalities) {
    ArrayList<String> imports = new ArrayList<String>();
    for (final Functionality functionality : functionalities) {
      {
        Attribute _input = functionality.getInput();
        boolean _tripleNotEquals = (_input != null);
        if (_tripleNotEquals) {
          String import_ = Extensions.getNativeFullyQualifiedName(functionality.getInput());
          boolean _contains = imports.contains(import_);
          boolean _not = (!_contains);
          if (_not) {
            imports.add(import_);
          }
        }
        Attribute _output = functionality.getOutput();
        boolean _tripleNotEquals_1 = (_output != null);
        if (_tripleNotEquals_1) {
          String import__1 = Extensions.getNativeFullyQualifiedName(functionality.getOutput());
          boolean _contains_1 = imports.contains(import__1);
          boolean _not_1 = (!_contains_1);
          if (_not_1) {
            imports.add(import__1);
          }
        }
      }
    }
    return imports;
  }
  
  public static CharSequence generateFunctionalitiesInfoForManager(final List<Functionality> functionalities) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�FOR functionality : functionalities�    public static final FunctionalityInfo �functionality.name.toStaticFieldName� = �functionality.name.toFirstUpper�Functionality.INFO;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�ENDFOR�");
    _builder.newLine();
    return _builder;
  }
  
  public static CharSequence generateFunctionalitiesCallsForManager(final List<Functionality> functionalities) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�FOR functionality : functionalities�");
    _builder.newLine();
    _builder.append("�var String input=null�");
    _builder.newLine();
    _builder.append("�var String inputLower=null�");
    _builder.newLine();
    _builder.append("�var String output=null�");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static final CompletableFuture<�IF functionality.output !== null��output = functionality.output.type��ELSE�Void�ENDIF�> �functionality.name.toFirstLower�(�IF functionality.input !== null��input = functionality.input.type� �inputLower = input.toFirstLower��ENDIF�) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return call(�functionality.name.toStaticFieldName�, �functionality.name.toFirstUpper�Functionality.class, getCallingFunctionality(), �IF inputLower !== null��inputLower��ELSE�null�ENDIF�, �IF functionality.output === null�null�ELSE�result -> result�functionality.output.getDataOrNativeTypeFromJsonCreatorMethod��ENDIF�);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static final CompletableFuture<�IF functionality.output !== null��output = functionality.output.type��ELSE�Void�ENDIF�> �functionality.name.toFirstLower�(Functionality functionality�IF functionality.input !== null�, �input = functionality.input.type� �inputLower = input.toFirstLower��ENDIF�) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return call(�functionality.name.toStaticFieldName�, �functionality.name.toFirstUpper�Functionality.class, functionality, �IF inputLower !== null��inputLower��ELSE�null�ENDIF�, �IF functionality.output === null�null�ELSE�result -> result�functionality.output.getDataOrNativeTypeFromJsonCreatorMethod��ENDIF�);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�IF input !== null�    public static final CompletableFuture<�IF output !== null��output��ELSE�Void�ENDIF�> �functionality.name.toFirstLower�FromJson(String �inputLower�Json) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return callFromJson(�functionality.name.toStaticFieldName�, �functionality.name.toFirstUpper�Functionality.class, getCallingFunctionality(), �inputLower�Json, �IF functionality.output === null�null�ELSE�result -> result�functionality.output.getDataOrNativeTypeFromJsonCreatorMethod��ENDIF�);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�ENDIF�");
    _builder.newLine();
    _builder.append("�IF input !== null�    public static final CompletableFuture<�IF output !== null��output��ELSE�Void�ENDIF�> �functionality.name.toFirstLower�FromJson(Functionality callingFunctionality, String �inputLower�Json) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return callFromJson(�functionality.name.toStaticFieldName�, �functionality.name.toFirstUpper�Functionality.class, callingFunctionality, �inputLower�Json, �IF functionality.output === null�null�ELSE�result -> result�functionality.output.getDataOrNativeTypeFromJsonCreatorMethod��ENDIF�);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("�ENDIF�");
    _builder.newLine();
    _builder.append("�ENDFOR�");
    _builder.newLine();
    return _builder;
  }
}
