/**
 * Copyright 2019 MetaRing s.r.l.
 * 
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.metaring.generator.server_java.factories;

import com.metaring.generator.model.util.Extensions;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class ModuleFactory implements com.metaring.generator.model.factories.ModuleFactory {
  @Override
  public String getModuleInfoFilename(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.packagePath�/ModuleInfo.java");
    return _builder.toString();
  }
  
  @Override
  public String getModuleInfoContent(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.generatedPackageDeclaration�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public interface ModuleInfo {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
  
  @Override
  public String getIdentificationHelperFilename(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.packagePath�/IdentificationHelper.java");
    return _builder.toString();
  }
  
  @Override
  public String getIdentificationHelperContent(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.generatedPackageDeclaration�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import �\"functionality.FunctionalityContext\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class IdentificationHelper {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private static final String IDENTIFICATION_DATA = \"IDENTIFICATION_DATA\";");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static final IdentificationData getIdentificationData(FunctionalityContext functionalityContext) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return (IdentificationData) functionalityContext.getData().get(IDENTIFICATION_DATA);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
  
  @Override
  public String getIdentificationModuleInfoFilename(final com.metaring.generator.model.data.Module module) {
    String _replace = Extensions.combineWithSystemNamespace("auth/IdentificationModuleInfo").replace(".", "/");
    return (_replace + ".java");
  }
  
  @Override
  public String getIdentificationModuleInfoContent(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package �\"auth\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import �\"functionality.FunctionalityInfo\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public interface IdentificationModuleInfo {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static final FunctionalityInfo INFO = FunctionalityInfo.create(\"�module.fullyQualifiedName�.verifyIdentification\", true, false, false, \"�module.fullyQualifiedName�.IdentificationData\", \"java.lang.Boolean\");");
    _builder.newLine();
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
  
  @Override
  public String getVerifiyIdentificationFunctionalityFilename(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.packagePath�/VerifyIdentificationFunctionality.java");
    return _builder.toString();
  }
  
  @Override
  public String getVerifiyIdentificationFunctionalityContent(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.generatedPackageDeclaration�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import �\"functionality.AbstractFunctionality\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"functionality.GeneratedFunctionality\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import java.util.concurrent.CompletableFuture;");
    _builder.newLine();
    _builder.append("import �\"auth.IdentificationModuleInfo\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �module.packageFQN�.IdentificationData;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public abstract class VerifyIdentificationFunctionality extends AbstractFunctionality implements GeneratedFunctionality {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("static final VerifyIdentificationFunctionality INSTANCE = new VerifyIdentificationFunctionalityImpl();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected VerifyIdentificationFunctionality() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("super(IdentificationModuleInfo.INFO, Boolean.class);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> beforePreConditionCheck(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return beforePreConditionCheck(input == null ? null : (IdentificationData) input);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> beforePreConditionCheck(IdentificationData input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> preConditionCheck(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return preConditionCheck(input == null ? null : (IdentificationData) input);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected abstract CompletableFuture<Void> preConditionCheck(IdentificationData input) throws Exception;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> afterPreConditionCheck(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return afterPreConditionCheck(input == null ? null : (IdentificationData) input);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> afterPreConditionCheck(IdentificationData input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> beforeCall(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return beforeCall(input == null ? null : (IdentificationData) input);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> beforeCall(IdentificationData input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Object> call(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("CompletableFuture<Boolean> call = call(input == null ? null : (IdentificationData) input);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(call == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("final CompletableFuture<Object> response = new CompletableFuture<>();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("call.whenCompleteAsync((result, error) -> {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("if(error != null) {");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("response.completeExceptionally(error);");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("response.complete(result);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}, EXECUTOR);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return response;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected abstract CompletableFuture<Boolean> call(IdentificationData input) throws Exception;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> afterCall(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return afterCall(input == null ? null : (IdentificationData) input, output == null ? null : (Boolean) output);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> afterCall(IdentificationData input, Boolean output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> beforePostConditionCheck(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return beforePostConditionCheck(input == null ? null : (IdentificationData) input, output == null ? null : (Boolean) output);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> beforePostConditionCheck(IdentificationData input, Boolean output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> postConditionCheck(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return postConditionCheck(input == null ? null : (IdentificationData) input, output == null ? null : (Boolean) output);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected abstract CompletableFuture<Void> postConditionCheck(IdentificationData input, Boolean output) throws Exception;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> afterPostConditionCheck(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return afterPostConditionCheck(input == null ? null : (IdentificationData) input, output == null ? null : (Boolean) output);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> afterPostConditionCheck(IdentificationData input, Boolean output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final Object getInputFromJsonWork(String inputJson) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return IdentificationData.fromJson(inputJson);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
  
  @Override
  public String getLimitedAccessHelperFilename(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.packagePath�/LimitedAccessHelper.java");
    return _builder.toString();
  }
  
  @Override
  public String getLimitedAccessHelperContent(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.generatedPackageDeclaration�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import �\"functionality.FunctionalityContext\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class LimitedAccessHelper {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("private static final String ENABLE_DATA = \"ENABLE_DATA\";");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static final EnableData getEnableData(FunctionalityContext functionalityContext) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return (EnableData) functionalityContext.getData().get(ENABLE_DATA);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
  
  @Override
  public String getLimitedAccessModuleInfoFilename(final com.metaring.generator.model.data.Module module) {
    String _replace = Extensions.combineWithSystemNamespace("auth/LimitedAccessModuleInfo").replace(".", "/");
    return (_replace + ".java");
  }
  
  @Override
  public String getLimitedAccessModuleInfoContent(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package �\"auth\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import �\"functionality.FunctionalityInfo\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public interface LimitedAccessModuleInfo {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("public static final FunctionalityInfo INFO = FunctionalityInfo.create(\"�module.fullyQualifiedName�.verifyEnable\", true, false, false, \"�module.fullyQualifiedName�.EnableData\", \"java.lang.Boolean\");");
    _builder.newLine();
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
  
  @Override
  public String getVerifiyEnableFunctionalityFilename(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.packagePath�/VerifyEnableFunctionality.java");
    return _builder.toString();
  }
  
  @Override
  public String getVerifiyEnableFunctionalityContent(final com.metaring.generator.model.data.Module module) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("�module.generatedPackageDeclaration�");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import �\"functionality.AbstractFunctionality\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"functionality.GeneratedFunctionality\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �\"auth.LimitedAccessModuleInfo\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.append("import �module.packageFQN�.EnableData;");
    _builder.newLine();
    _builder.append("import java.util.concurrent.CompletableFuture;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public abstract class VerifyEnableFunctionality extends AbstractFunctionality implements GeneratedFunctionality {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("static final VerifyEnableFunctionality INSTANCE = new VerifyEnableFunctionalityImpl();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected VerifyEnableFunctionality() {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("super(LimitedAccessModuleInfo.INFO, Boolean.class);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> beforePreConditionCheck(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return beforePreConditionCheck(input == null ? null : (EnableData) input);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> beforePreConditionCheck(EnableData input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> preConditionCheck(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return preConditionCheck(input == null ? null : (EnableData) input);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected abstract CompletableFuture<Void> preConditionCheck(EnableData input) throws Exception;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> afterPreConditionCheck(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return afterPreConditionCheck(input == null ? null : (EnableData) input);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> afterPreConditionCheck(EnableData input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> beforeCall(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return beforeCall(input == null ? null : (EnableData) input);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> beforeCall(EnableData input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Object> call(Object input) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("CompletableFuture<Boolean> call = call(input == null ? null : (EnableData) input);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("if(call == null) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("final CompletableFuture<Object> response = new CompletableFuture<>();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("call.whenCompleteAsync((result, error) -> {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("if(error != null) {");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("response.completeExceptionally(error);");
    _builder.newLine();
    _builder.append("                ");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("response.complete(result);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}, EXECUTOR);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return response;");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected abstract CompletableFuture<Boolean> call(EnableData input) throws Exception;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> afterCall(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return afterCall(input == null ? null : (EnableData) input, output == null ? null : (Boolean) output);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> afterCall(EnableData input, Boolean output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> beforePostConditionCheck(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return beforePostConditionCheck(input == null ? null : (EnableData) input, output == null ? null : (Boolean) output);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> beforePostConditionCheck(EnableData input, Boolean output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> postConditionCheck(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return postConditionCheck(input == null ? null : (EnableData) input, output == null ? null : (Boolean) output);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected abstract CompletableFuture<Void> postConditionCheck(EnableData input, Boolean output) throws Exception;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final CompletableFuture<Void> afterPostConditionCheck(Object input, Object output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return afterPostConditionCheck(input == null ? null : (EnableData) input, output == null ? null : (Boolean) output);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected CompletableFuture<Void> afterPostConditionCheck(EnableData input, Boolean output) throws Exception {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return CompletableFuture.completedFuture(null);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("protected final Object getInputFromJsonWork(String inputJson) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("return EnableData.fromJson(inputJson);");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
  
  @Override
  public String getEmailModuleFilename() {
    String _replace = Extensions.combineWithSystemNamespace("email/EmailTemplatesModuleInfo").replace(".", "/");
    return (_replace + ".java");
  }
  
  @Override
  public String getEmailModuleContent() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package �\"email\".combineWithSystemNamespace�;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public interface EmailTemplatesModuleInfo {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
}
