/**
 *    Copyright 2019 MetaRing s.r.l.
 * 
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package com.metaring.java.process.fork;

import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.function.BiConsumer;

class ProcessStreamReader extends Thread {

    private BufferedReader reader;
    private PrintStream printWriter;
    private BiConsumer<Process, Exception> callback;

    ProcessStreamReader(BufferedReader reader, PrintStream printWriter) {
        super();
        this.reader = reader;
        this.printWriter = printWriter;
        this.callback = null;
        this.start();
    }

    ProcessStreamReader(BufferedReader reader, PrintStream printWriter, BiConsumer<Process, Exception> callback) {
        super();
        this.reader = reader;
        this.printWriter = printWriter;
        this.callback = callback;
        this.start();
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                printWriter.println(line);
            }
        }
        catch (Exception e) {
            if (callback != null) {
                callback.accept(null, e);
            }
        }
    }
}
