/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.java.process.fork;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.management.VMManagement;

public class PidRetriever {
    private boolean byHandle = false;
    private long pid;

    public static final long getMyPid() throws Exception {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        Field jvm = runtime.getClass().getDeclaredField("jvm");
        jvm.setAccessible(true);
        VMManagement mgmt = (VMManagement)jvm.get(runtime);
        Method pid_method = mgmt.getClass().getDeclaredMethod("getProcessId", new Class[0]);
        pid_method.setAccessible(true);
        return Long.parseLong(pid_method.invoke((Object)mgmt, new Object[0]).toString());
    }

    public static final PidRetriever getProcessPid(Process process) {
        PidRetriever pidRetriever = new PidRetriever();
        try {
            Class<?> processImplClass = process.getClass();
            Field processPidField = null;
            try {
                processPidField = processImplClass.getDeclaredField("pid");
            }
            catch (Exception e) {
                processPidField = processImplClass.getDeclaredField("handle");
                pidRetriever.byHandle = true;
            }
            processPidField.setAccessible(true);
            pidRetriever.pid = Long.parseLong(processPidField.get(process).toString());
            if (pidRetriever.byHandle) {
                pidRetriever.pid = PidRetriever.getPidByHandle(pidRetriever.pid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pidRetriever;
    }

    private static final long getPidByHandle(long handleId) {
        try {
            Kernel32 kernel = Kernel32.INSTANCE;
            WinNT.HANDLE handle = new WinNT.HANDLE();
            Pointer pointer = Pointer.createConstant((long)handleId);
            handle.setPointer(pointer);
            long pid = kernel.GetProcessId(handle);
            if (pid == 0L) {
                pid = handleId;
            }
            return pid;
        }
        catch (Exception e) {
            e.printStackTrace();
            return handleId;
        }
    }

    private PidRetriever() {
    }

    public boolean isByHandle() {
        return this.byHandle;
    }

    public long getPid() {
        return this.pid;
    }
}

