/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.java.process.fork;

import com.metaring.java.process.fork.PidRetriever;
import com.metaring.java.process.fork.ProcessKiller;
import com.metaring.java.process.fork.ProcessStreamReader;
import com.metaring.java.process.fork.ProcessWaiter;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.function.BiConsumer;

public class JavaChildProcess {
    public static final boolean IS_WINDOWS = !File.pathSeparator.equals(":");
    public static final String QUOTES = IS_WINDOWS ? "\"" : "";
    static final String CLOSE_KEY = JavaChildProcess.class.getName() + ".KILL";
    static final String CONMMAND_SEPARATOR = "[ - SEPARATOR - ][" + JavaChildProcess.class.getName() + "][ - SEPARATOR - ]";

    public static void main(String[] args) throws Exception {
        File[] tempFilesToDelete;
        String[] commands = null;
        String folder = null;
        try (Scanner scanner = new Scanner(JavaChildProcess.class.getClassLoader().getResourceAsStream("context.txt"));){
            String line;
            folder = scanner.nextLine();
            ArrayList<String> l = new ArrayList<String>();
            while (!(line = scanner.nextLine()).equalsIgnoreCase(CONMMAND_SEPARATOR)) {
                l.add(line);
            }
            commands = l.toArray(new String[l.size()]);
            ArrayList<File> files = new ArrayList<File>();
            while (scanner.hasNext()) {
                files.add(new File(scanner.nextLine()));
            }
            tempFilesToDelete = files.toArray(new File[files.size()]);
        }
        String finalFolder = folder;
        String javaCommand = QUOTES + System.getProperty("java.home").replace("\\", "/");
        if (!javaCommand.endsWith("/")) {
            javaCommand = javaCommand + "/";
        }
        javaCommand = javaCommand + "bin/java" + QUOTES;
        ArrayList<String> finalJavaCommands = new ArrayList<String>();
        finalJavaCommands.add(javaCommand);
        finalJavaCommands.add("-cp");
        finalJavaCommands.add(QUOTES + folder + QUOTES);
        finalJavaCommands.add(JavaChildProcess.class.getName());
        if (args != null && args.length > 0) {
            boolean alsoFolder = true;
            boolean isByHandle = Boolean.parseBoolean(args[1]);
            long pid = -1L;
            if (args[0].equalsIgnoreCase("c")) {
                pid = Long.parseLong(args[2]);
            } else {
                try (Scanner scanner2 = new Scanner(System.in);){
                    alsoFolder = false;
                    pid = Long.parseLong(scanner2.nextLine());
                    scanner2.nextLine();
                }
                catch (Exception scanner2) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(1700L);
            }
            catch (Exception scanner2) {
                // empty catch block
            }
            try {
                JavaChildProcess.exit(null, isByHandle, pid, tempFilesToDelete, finalFolder, finalJavaCommands, alsoFolder);
            }
            catch (Exception scanner2) {}
        } else {
            ArrayList<Boolean> keepRunning = new ArrayList<Boolean>();
            keepRunning.add(true);
            Process finalProcess = Runtime.getRuntime().exec(commands);
            PidRetriever pidRetriever = PidRetriever.getProcessPid(finalProcess);
            System.out.println(pidRetriever.isByHandle());
            System.out.println(pidRetriever.getPid());
            BiConsumer<Process, Exception> processConsumer = (p, e) -> {
                if (e != null) {
                    e.printStackTrace();
                }
                if (p != null && !p.isAlive() && !keepRunning.isEmpty()) {
                    System.err.println("Process not alive anymore. Exiting and Cleaning temp files...");
                    try {
                        JavaChildProcess.exit(finalProcess, pidRetriever.isByHandle(), pidRetriever.getPid(), tempFilesToDelete, finalFolder, finalJavaCommands, false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.exit(200);
                }
            };
            new ProcessWaiter(finalProcess, processConsumer);
            new ProcessStreamReader(new BufferedReader(new InputStreamReader(finalProcess.getErrorStream())), System.err, processConsumer);
            new ProcessStreamReader(new BufferedReader(new InputStreamReader(finalProcess.getInputStream())), System.out, processConsumer);
            PrintWriter printWriter = new PrintWriter(finalProcess.getOutputStream());
            try (Scanner scanner = new Scanner(System.in);){
                while (!keepRunning.isEmpty()) {
                    String line = scanner.nextLine();
                    if (line == null || line.equalsIgnoreCase(CLOSE_KEY)) {
                        keepRunning.remove(0);
                        break;
                    }
                    printWriter.println(line);
                    printWriter.flush();
                }
            }
            catch (Exception e2) {
                keepRunning.remove(0);
            }
            try {
                JavaChildProcess.exit(finalProcess, pidRetriever.isByHandle(), pidRetriever.getPid(), tempFilesToDelete, finalFolder, finalJavaCommands, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static final void exit(Process process, boolean isByHandle, long pid, File[] tempFilesToDelete, String folder, List<String> javaCommands, boolean alsoFolder) {
        try {
            process.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ProcessKiller.kill(pid, isByHandle);
        try {
            Thread.sleep(700L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tempFilesToDelete != null && tempFilesToDelete.length > 0) {
            for (File file : tempFilesToDelete) {
                JavaChildProcess.delete(file);
            }
        }
        if (alsoFolder) {
            JavaChildProcess.delete(new File(folder));
        } else {
            try {
                ArrayList<String> cleanCommands = new ArrayList<String>();
                cleanCommands.addAll(javaCommands);
                cleanCommands.add("c");
                cleanCommands.add("" + isByHandle);
                cleanCommands.add("" + pid);
                Runtime.getRuntime().exec(cleanCommands.toArray(new String[cleanCommands.size()]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final void delete(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    JavaChildProcess.delete(f);
                    continue;
                }
                f.delete();
                f.deleteOnExit();
            }
        }
        file.delete();
        file.deleteOnExit();
    }
}

