/*
 * Decompiled with CFR 0.152.
 */
package com.migratorydata.client;

import com.migratorydata.client.MigratoryDataMessage;
import com.migratorydata.client.Y;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;

public class MigratoryDataKafkaUtils {
    public static ProducerRecord<String, byte[]> createRecord(String topic, String key, byte[] value, boolean compression, MigratoryDataMessage.QoS qos, boolean retained) {
        ProducerRecord record = new ProducerRecord(topic, (Object)key, (Object)MigratoryDataKafkaUtils.a(value, compression));
        MigratoryDataKafkaUtils.a((ProducerRecord<String, byte[]>)record, compression, qos, retained);
        return record;
    }

    public static ProducerRecord<String, byte[]> createRecord(String topic, int partition, String key, byte[] value, boolean compression, MigratoryDataMessage.QoS qos, boolean retained) {
        ProducerRecord record = new ProducerRecord(topic, Integer.valueOf(partition), (Object)key, (Object)MigratoryDataKafkaUtils.a(value, compression));
        MigratoryDataKafkaUtils.a((ProducerRecord<String, byte[]>)record, compression, qos, retained);
        return record;
    }

    public static ProducerRecord<String, byte[]> createRecord(String topic, int partition, long timestamp, String key, byte[] value, boolean compression, MigratoryDataMessage.QoS qos, boolean retained) {
        ProducerRecord record = new ProducerRecord(topic, Integer.valueOf(partition), Long.valueOf(timestamp), (Object)key, (Object)MigratoryDataKafkaUtils.a(value, compression));
        MigratoryDataKafkaUtils.a((ProducerRecord<String, byte[]>)record, compression, qos, retained);
        return record;
    }

    public static byte[] getRecordValue(ConsumerRecord<String, byte[]> record) {
        Header compression;
        Header pushVersion = record.headers().lastHeader("pushVersion");
        byte[] value = (byte[])record.value();
        if (pushVersion != null && (compression = record.headers().lastHeader("compression")) != null && compression.value()[0] == 1) {
            value = MigratoryDataKafkaUtils.b(value);
        }
        return value;
    }

    private static byte[] a(byte[] value, boolean compression) {
        byte[] valueProcess = value;
        if (compression) {
            valueProcess = MigratoryDataKafkaUtils.a(value);
        }
        return valueProcess;
    }

    private static byte[] a(byte[] data) {
        Deflater compressor = new Deflater(-1, true);
        compressor.setInput(data);
        compressor.finish();
        ByteBuffer compressData = ByteBuffer.allocate(8192);
        byte[] compressChunk = new byte[8192];
        do {
            int written = compressor.deflate(compressChunk);
            compressData.put(compressChunk, 0, written);
        } while (!compressor.finished());
        compressor.end();
        compressData.flip();
        return Base64.getEncoder().encode(Arrays.copyOf(compressData.array(), compressData.limit() - compressData.position()));
    }

    private static byte[] b(byte[] data) {
        ByteBuffer resultDecompress = ByteBuffer.allocate(8192);
        Inflater decompress = null;
        try {
            byte[] decompressChunk = new byte[8192];
            byte[] decodedData = Base64.getDecoder().decode(data);
            decompress = new Inflater(true);
            decompress.setInput(decodedData);
            do {
                int read = decompress.inflate(decompressChunk);
                resultDecompress.put(decompressChunk, 0, read);
            } while (!decompress.finished());
            resultDecompress.flip();
            byte[] byArray = Arrays.copyOf(resultDecompress.array(), resultDecompress.limit() - resultDecompress.position());
            decompress.end();
            return byArray;
        }
        catch (IllegalArgumentException | DataFormatException exception) {
            Exception e1 = exception;
            exception.printStackTrace();
            byte[] byArray = data;
            return byArray;
        }
        finally {
            if (decompress != null) {
                decompress.end();
            }
        }
    }

    private static void a(ProducerRecord<String, byte[]> record, boolean compression, MigratoryDataMessage.QoS qos, boolean retained) {
        record.headers().add("qos", new byte[]{(byte)qos.code()});
        record.headers().add("compression", new byte[]{(byte)(compression ? 1 : 0)});
        record.headers().add("retained", new byte[]{(byte)(retained ? 1 : 0)});
        record.headers().add("pushVersion", "6.0.0".getBytes());
        record.headers().add("timestamp", Y.bk().x((int)(System.currentTimeMillis() & 0xFFFFFFL)));
    }
}

