/*
 * Decompiled with CFR 0.152.
 */
package com.nauth.api;

import com.nauth.api.ImageType;
import com.nauth.api.LoginInformation;
import com.nauth.api.NAuthAccount;
import com.nauth.api.NAuthBackend;
import com.nauth.api.NAuthServerException;
import com.nauth.api.RequestType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NAuth {
    private final String serverURI;
    private final String serverId;
    private final String apiKey;
    private final NAuthBackend backend;
    private final String realm;

    public NAuth(String serverURI, String serverId, String apiKey, String realm, boolean useSSL, String pk, List<String> ciphers) throws NAuthServerException {
        this.serverURI = serverURI;
        this.serverId = serverId;
        this.apiKey = apiKey;
        this.realm = realm;
        this.backend = useSSL ? new NAuthBackend(pk, ciphers) : new NAuthBackend();
    }

    public NAuth(String serverURI, String serverId, String apiKey, String realm) throws NAuthServerException {
        this(serverURI, serverId, apiKey, realm, false, null, null);
    }

    private String serverGet(String method, String[] queryParts, Map<String, String> params) throws NAuthServerException {
        return this.backend.getHttpAsString(method, this.serverURI, queryParts, params, this.getHeaders());
    }

    private byte[] serverGetBytes(String method, String[] queryParts, Map<String, String> params) throws NAuthServerException {
        return this.backend.getHttpAsBytes(method, this.serverURI, queryParts, params, this.getHeaders());
    }

    public void logout(String sessionId) throws NAuthServerException {
        this.serverGet("POST", new String[]{"servers", this.serverId, "sessions", sessionId, "logout"}, null);
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-ApiKey", this.apiKey);
        return headers;
    }

    private JSONObject sessionCheck(String sessionId) throws NAuthServerException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("realm", this.realm);
        JSONParser parser = new JSONParser();
        try {
            return (JSONObject)parser.parse(this.serverGet("GET", new String[]{"servers", this.serverId, "sessions", sessionId}, params));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public LoginInformation tryLogin(String sessionId) throws NAuthServerException {
        JSONObject loginData = this.sessionCheck(sessionId);
        if (loginData == null) {
            return null;
        }
        return new LoginInformation((Boolean)loginData.get((Object)"loggedin"), (Boolean)loginData.get((Object)"canprovoke"), (String)loginData.get((Object)"userid"), (String)loginData.get((Object)"loginqrdata"), (String)loginData.get((Object)"pk"), (String)loginData.get((Object)"hsid"));
    }

    public boolean registerUser(String sessionId, String userId) throws NAuthServerException {
        if (!this.tryLogin(sessionId).isLoggedIn()) {
            return false;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("realm", this.realm);
        params.put("userid", userId);
        this.serverGet("POST", new String[]{"servers", this.serverId, "sessions", sessionId, "registeruser"}, params);
        return true;
    }

    public byte[] getLoginImage(String sessionId, ImageType imgtype, int size) throws NAuthServerException {
        if (imgtype == null) {
            imgtype = ImageType.QR;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("realm", this.realm);
        params.put("userid", null);
        params.put("type", RequestType.LOGIN.toString());
        params.put("name", null);
        params.put("s", "" + size);
        if (imgtype != ImageType.RAWDATA) {
            params.put("img", imgtype.toString());
        }
        return this.serverGetBytes("GET", new String[]{"servers", this.serverId, "sessions", sessionId, "qr"}, params);
    }

    public byte[] getRegisterImage(ImageType imgtype, String sessionId, String userId, String name, int size) throws NAuthServerException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("realm", this.realm);
        params.put("userid", userId);
        params.put("type", RequestType.REGISTER.toString());
        params.put("name", name);
        params.put("s", size + "");
        if (imgtype != ImageType.RAWDATA) {
            params.put("img", ImageType.QR.toString());
        }
        return this.serverGetBytes("GET", new String[]{"servers", this.serverId, "sessions", sessionId, "qr"}, params);
    }

    public byte[] getRegisterImage(String sessionId, String userId, String name, int size) throws NAuthServerException {
        return this.getRegisterImage(ImageType.QR, sessionId, userId, name, size);
    }

    public boolean provokeloginOnSession(String sessionId) throws NAuthServerException {
        String result = this.serverGet("POST", new String[]{"servers", this.serverId, "sessions", sessionId, "provokelogin"}, null);
        JSONParser parser = new JSONParser();
        try {
            JSONObject obj = (JSONObject)parser.parse(result);
            Boolean ret = (Boolean)obj.get((Object)"result");
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean provokeloginOnAccount(String sessionId, String accountId) throws NAuthServerException {
        String result = this.serverGet("POST", new String[]{"servers", this.serverId, "accounts", accountId, "provokelogin", sessionId, "provokelogin"}, null);
        JSONParser parser = new JSONParser();
        try {
            JSONObject obj = (JSONObject)parser.parse(result);
            Boolean ret = (Boolean)obj.get((Object)"result");
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean provokeloginOnUser(String sessionId, String userId) throws NAuthServerException {
        String result = this.serverGet("POST", new String[]{"servers", this.serverId, "users", userId, "provokelogin", sessionId, "provokelogin"}, null);
        JSONParser parser = new JSONParser();
        try {
            JSONObject obj = (JSONObject)parser.parse(result);
            Boolean ret = (Boolean)obj.get((Object)"result");
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<NAuthAccount> getUserAccountsFor(String userid) throws NAuthServerException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("realm", this.realm);
        String data = this.serverGet("GET", new String[]{"servers", this.serverId, "users", userid}, params);
        JSONParser jsonParser = new JSONParser();
        try {
            JSONArray accounts = (JSONArray)jsonParser.parse(data);
            return this.convertToAccounts(accounts);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<NAuthAccount>();
        }
    }

    private List<NAuthAccount> convertToAccounts(JSONArray accounts) {
        if (accounts == null) {
            return new ArrayList<NAuthAccount>();
        }
        ArrayList<NAuthAccount> nAuthAccounts = new ArrayList<NAuthAccount>();
        for (int i = 0; i < accounts.size(); ++i) {
            nAuthAccounts.add(this.convertToAccount((JSONObject)accounts.get(i)));
        }
        return nAuthAccounts;
    }

    private NAuthAccount convertToAccount(JSONObject account) {
        return new NAuthAccount((Long)account.get((Object)"id"), (Boolean)account.get((Object)"publicKeyAuthRevoked"), (Boolean)account.get((Object)"publicKeyTransRevoked"), (String)account.get((Object)"description"), new Date((Long)account.get((Object)"lastlogin")), new Date((Long)account.get((Object)"created")), (Boolean)account.get((Object)"blocked"));
    }

    public JSONArray getUsers() throws NAuthServerException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("realm", this.realm);
        String data = this.serverGet("GET", new String[]{"servers", this.serverId, "users"}, params);
        JSONParser jsonParser = new JSONParser();
        try {
            return (JSONArray)jsonParser.parse(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JSONArray();
        }
    }

    public boolean blockAccount(String userid, boolean blocked) throws NAuthServerException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("realm", this.realm);
        params.put("blocked", blocked ? "true" : "false");
        this.serverGet("PUT", new String[]{"servers", this.serverId, "users", userid}, params);
        return true;
    }

    public boolean deleteAccount(Long accountId) throws NAuthServerException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("realm", this.realm);
        this.serverGet("DELETE", new String[]{"servers", this.serverId, "accounts", String.valueOf(accountId)}, params);
        return true;
    }

    public String createTransaction(String sessionId, String msg) throws NAuthServerException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("msg", msg);
        String result = this.serverGet("POST", new String[]{"servers", this.serverId, "sessions", sessionId, "transactions"}, params);
        JSONParser parser = new JSONParser();
        try {
            JSONObject obj = (JSONObject)parser.parse(result);
            Boolean ret = (Boolean)obj.get((Object)"result");
            if (ret.booleanValue()) {
                return (String)obj.get((Object)"tid");
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Integer checkTransaction(String sessionId, String transactionId) throws NAuthServerException {
        String result = this.serverGet("GET", new String[]{"servers", this.serverId, "sessions", sessionId, "transactions", transactionId}, null);
        JSONParser parser = new JSONParser();
        try {
            JSONObject obj = (JSONObject)parser.parse(result);
            Boolean ret = (Boolean)obj.get((Object)"result");
            if (ret.booleanValue()) {
                return (Integer)obj.get((Object)"tstatus");
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getVashImage() throws NAuthServerException {
        return this.serverGetBytes("GET", new String[]{"servers", this.serverId, "vash"}, new HashMap<String, String>());
    }
}

