/*
 * Decompiled with CFR 0.152.
 */
package com.nauth.api;

import com.nauth.api.NAuthServerException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class NAuthBackend {
    protected boolean useSSL;
    private SSLConnectionSocketFactory sslsf;
    public static final String DEFAULT_PK = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuJlaS3XZdRpcT/uek5nxX4iqn/7As1BY2VACO8wSM3m7VG6iN/Py2jTguIfVJcQhtk1sy7elG0AXDKO3peWc+of4pHTpQ9kaFcvFisi6uDcDWAIJMjiSE2iAm8veZ+5LddqDD/iItRYul4mFsKIl8Q6DKBvKkHjn3tXC2g3bvvsY689qbH7FhKpueGx8Z+yKvV209FGSkFKI+sGOB/C4OeF/KX3FTw/gMMD0YrS2skV+lg3jGTNzNep7Gfhuz4j4CrKXx67p7x3EV8m2kDDIQMwWi/rxSJ2V/0sKbUebnsozUDpWi1blRJjtSW27tFVxrffXWrpw4O5HxEcMtB65RQIDAQAB";
    public static final List<String> DEFAULT_CIPHERS = Arrays.asList("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");

    public NAuthBackend() {
        this.useSSL = false;
    }

    public NAuthBackend(String pk, List<String> ciphers) throws NAuthServerException {
        this.useSSL = true;
        this.setupSSLContext(pk == null ? DEFAULT_PK : pk, ciphers == null ? DEFAULT_CIPHERS : ciphers);
    }

    private void setupSSLContext(final String pk, List<String> cipherList) throws NAuthServerException {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            ctx.init(null, null, null);
            SSLParameters params = ctx.getDefaultSSLParameters();
            ArrayList<String> ciphers = new ArrayList<String>(Arrays.asList(params.getCipherSuites()));
            ciphers.retainAll(cipherList);
            this.sslsf = new SSLConnectionSocketFactory(ctx, new String[]{"TLSv1.2"}, ciphers.toArray(new String[ciphers.size()]), new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    try {
                        Certificate cert = session.getPeerCertificates()[0];
                        return pk.equals(Base64.getEncoder().encodeToString(cert.getPublicKey().getEncoded()));
                    }
                    catch (SSLPeerUnverifiedException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            });
        }
        catch (NoSuchAlgorithmException e) {
            throw new NAuthServerException(e);
        }
        catch (KeyManagementException e) {
            throw new NAuthServerException(e);
        }
    }

    private CloseableHttpClient getHttpClient() {
        if (this.useSSL) {
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslsf).build();
        }
        return HttpClients.createDefault();
    }

    /*
     * Exception decompiling
     */
    public byte[] getHttpAsBytes(String method, String uri, String[] action, Map<String, String> params, Map<String, String> headers) throws NAuthServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String readInputStream(InputStream inputStream) throws IOException {
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName(StandardCharsets.UTF_8.name())));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        return textBuilder.toString();
    }

    private static byte[] readInputStreamAsBytes(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private URI getUri(String uri, String[] action, Map<String, String> params) throws NAuthServerException {
        try {
            String fulluri = uri + "/";
            for (String part : action) {
                try {
                    fulluri = fulluri + URLEncoder.encode(part, "UTF-8") + "/";
                }
                catch (UnsupportedEncodingException e) {
                    throw new NAuthServerException(e);
                }
            }
            URIBuilder builder = new URIBuilder(fulluri);
            if (params != null) {
                for (Map.Entry entry : params.entrySet()) {
                    builder.addParameter((String)entry.getKey(), (String)entry.getValue());
                }
            }
            URI ret = builder.build();
            return ret;
        }
        catch (URISyntaxException e) {
            throw new NAuthServerException(e);
        }
    }

    private HttpUriRequest getRequestByMethod(String method, URI uri) {
        switch (method) {
            default: {
                return new HttpGet(uri);
            }
            case "POST": {
                return new HttpPost(uri);
            }
            case "DELETE": {
                return new HttpDelete(uri);
            }
            case "PUT": {
                return new HttpPut(uri);
            }
            case "OPTIONS": 
        }
        return new HttpOptions(uri);
    }

    /*
     * Exception decompiling
     */
    public String getHttpAsString(String method, String uri, String[] action, Map<String, String> params, Map<String, String> headers) throws NAuthServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processStatusCode(CloseableHttpResponse response) throws NAuthServerException {
        int code = response.getStatusLine().getStatusCode();
        if (code >= 200 && code < 300) {
            return;
        }
        throw new NAuthServerException("HTTP response " + code + " " + response.getStatusLine().getReasonPhrase());
    }
}

