/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.log.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.nesscomputing.httpserver.log.LogFields;
import com.nesscomputing.httpserver.log.file.FileRequestLogConfig;
import com.nesscomputing.logging.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

@Singleton
public class FileRequestLog
extends AbstractLifeCycle
implements RequestLog {
    private static final Log LOG = Log.findLog();
    private final List<String> logFields;
    private final Set<String> blackList;
    private final File requestLogFile;
    private final AtomicReference<PrintWriter> requestLogWriterHolder = new AtomicReference();
    private final Map<String, LogFields.LogField> knownFields;

    @Inject
    public FileRequestLog(FileRequestLogConfig requestLogConfig, Map<String, LogFields.LogField> knownFields) {
        List<String> logFields = requestLogConfig.getLogFields();
        LogFields.validateLogFields(knownFields, logFields);
        this.logFields = logFields;
        this.blackList = requestLogConfig.getBlacklist();
        this.requestLogFile = new File(requestLogConfig.getFileName());
        this.knownFields = knownFields;
    }

    public void doStart() {
        if (this.requestLogFile.exists() && !this.requestLogFile.isFile()) {
            LOG.warn("Log file \"%s\" exists, but is not a file!", new Object[]{this.requestLogFile.getAbsolutePath()});
            return;
        }
        File logPath = this.requestLogFile.getParentFile();
        if (!logPath.mkdirs() && !logPath.exists()) {
            LOG.warn("Cannot create \"%s\" and path does not already exist!", new Object[]{logPath.getAbsolutePath()});
        }
        LOG.info("Opening request log at \"%s\"", new Object[]{this.requestLogFile.getAbsolutePath()});
        try {
            this.setWriter(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(this.requestLogFile, true), Charsets.UTF_8), true));
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e, "Could not open request log \"%s\"", new Object[]{this.requestLogFile.getAbsolutePath()});
        }
    }

    @VisibleForTesting
    void setWriter(PrintWriter printWriter) {
        if (!this.requestLogWriterHolder.compareAndSet(null, printWriter)) {
            Closeables.closeQuietly((Closeable)printWriter);
        }
    }

    public void doStop() {
        PrintWriter requestLogWriter = this.requestLogWriterHolder.getAndSet(null);
        if (requestLogWriter != null) {
            LOG.info("Closing request log \"%s\"", new Object[]{this.requestLogFile.getAbsolutePath()});
            Closeables.closeQuietly((Closeable)requestLogWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Request request, Response response) {
        String requestUri = request.getRequestURI();
        for (String blackListEntry : this.blackList) {
            if (!StringUtils.startsWith((CharSequence)requestUri, (CharSequence)blackListEntry)) continue;
            return;
        }
        PrintWriter requestLogWriter = this.requestLogWriterHolder.get();
        if (requestLogWriter != null) {
            FileRequestLog fileRequestLog = this;
            synchronized (fileRequestLog) {
                Iterator<String> it = this.logFields.iterator();
                while (it.hasNext()) {
                    String[] chunks = StringUtils.split((String)it.next(), (String)":");
                    LogFields.LogField field = this.knownFields.get(chunks[0]);
                    if (chunks.length == 1) {
                        requestLogWriter.print(ObjectUtils.toString((Object)field.log(request, response, null)));
                    } else if (chunks.length == 2) {
                        requestLogWriter.print(ObjectUtils.toString((Object)field.log(request, response, chunks[1])));
                    }
                    if (!it.hasNext()) continue;
                    requestLogWriter.print("\t");
                }
                requestLogWriter.println();
            }
        }
    }
}

