/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.inject.Singleton;
import com.nesscomputing.logging.Log;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
class InvalidRequestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.findLog();

    InvalidRequestServlet() {
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        LOG.warn("Invalid request: %s %s!", new Object[]{req.getMethod(), req.getRequestURI()});
        res.setStatus(404);
        res.setCharacterEncoding("UTF-8");
        res.setContentType("text/plain");
        PrintWriter w = res.getWriter();
        ((Writer)w).write(String.format("Invalid request to %s '%s'", req.getMethod(), req.getRequestURI()));
    }
}

