/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.assets;

import com.neuronrobotics.bowlerstudio.BowlerKernel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class StudioBuildInfo {
    private static Class baseBuildInfoClass = BowlerKernel.class;

    public static String getVersion() {
        String s = StudioBuildInfo.getTag("app.version");
        if (s == null) {
            throw new RuntimeException("Failed to load version number");
        }
        return s;
    }

    public static int getProtocolVersion() {
        return StudioBuildInfo.getBuildInfo()[0];
    }

    public static int getSDKVersion() {
        return StudioBuildInfo.getBuildInfo()[1];
    }

    public static int getBuildVersion() {
        return StudioBuildInfo.getBuildInfo()[2];
    }

    public static int[] getBuildInfo() {
        try {
            String s = StudioBuildInfo.getVersion();
            String[] splits = s.split("[.]+");
            int[] rev = new int[3];
            for (int i = 0; i < 3; ++i) {
                rev[i] = new Integer(splits[i]);
            }
            return rev;
        }
        catch (NumberFormatException e) {
            return new int[]{0, 0, 0};
        }
    }

    private static String getTag(String target) {
        try {
            String[] splitAll;
            StringBuilder s = new StringBuilder();
            InputStream is = StudioBuildInfo.getBuildPropertiesStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                String line;
                while (null != (line = br.readLine())) {
                    s.append(line).append("\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String aSplitAll : splitAll = s.toString().split("[\n]+")) {
                if (!aSplitAll.contains(target)) continue;
                String[] split = aSplitAll.split("[=]+");
                return split[1];
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return null;
    }

    public static String getBuildDate() {
        String s = "";
        InputStream is = StudioBuildInfo.class.getResourceAsStream("/META-INF/MANIFEST.MF");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while (null != (line = br.readLine())) {
                s = s + line + "\n";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    private static InputStream getBuildPropertiesStream() {
        return baseBuildInfoClass.getResourceAsStream("build.properties");
    }

    public static String getSDKVersionString() {
        return StudioBuildInfo.getName();
    }

    public static boolean isOS64bit() {
        return System.getProperty("os.arch").contains("64");
    }

    public static boolean isARM() {
        return System.getProperty("os.arch").toLowerCase().contains("arm");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    public static boolean isUnix() {
        return StudioBuildInfo.isLinux() || StudioBuildInfo.isMac();
    }

    public static Class getBaseBuildInfoClass() {
        return baseBuildInfoClass;
    }

    public static void setBaseBuildInfoClass(Class c) {
        baseBuildInfoClass = c;
    }

    public static String getName() {
        return "Bowler Studio " + StudioBuildInfo.getProtocolVersion() + "." + StudioBuildInfo.getSDKVersion() + "(" + StudioBuildInfo.getBuildVersion() + ")";
    }
}

