/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.av;

import com.neuronrobotics.bowlerstudio.av.ImageDataSource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class ImagesToVideo
implements ControllerListener,
DataSinkListener {
    Object waitSync = new Object();
    boolean stateTransitionOK = true;
    Object waitFileSync = new Object();
    boolean fileDone = false;
    boolean fileSuccess = true;

    public boolean run(int width, int height, int frameRate, ArrayList<File> inFiles, File outputFile) {
        Vector<String> inputFiles = new Vector<String>();
        for (File f : inFiles) {
            inputFiles.addElement(f.getAbsolutePath());
        }
        String outputURL = outputFile.getAbsolutePath();
        if (!outputURL.endsWith(".mov") && !outputURL.endsWith(".MOV")) {
            throw new RuntimeException("The output file extension should end with a .mov extension");
        }
        MediaLocator oml = ImagesToVideo.createMediaLocator(outputFile.getAbsolutePath());
        return this.run(width, height, frameRate, inputFiles, oml);
    }

    public boolean run(int width, int height, int frameRate, Vector<String> inFiles, MediaLocator outML) {
        Processor p;
        ImageDataSource ids = new ImageDataSource(width, height, frameRate, inFiles);
        try {
            System.err.println("- create processor for the image datasource ...");
            p = Manager.createProcessor((DataSource)ids);
        }
        catch (Exception e) {
            System.err.println("Yikes!  Cannot create a processor from the data source.");
            return false;
        }
        p.addControllerListener((ControllerListener)this);
        p.configure();
        if (!this.waitForState(p, 180)) {
            System.err.println("Failed to configure the processor.");
            return false;
        }
        p.setContentDescriptor(new ContentDescriptor("video.quicktime"));
        TrackControl[] tcs = p.getTrackControls();
        Format[] f = tcs[0].getSupportedFormats();
        if (f == null || f.length <= 0) {
            System.err.println("The mux does not support the input format: " + tcs[0].getFormat());
            return false;
        }
        tcs[0].setFormat(f[0]);
        System.err.println("Setting the track format to: " + f[0]);
        p.realize();
        if (!this.waitForState(p, 300)) {
            System.err.println("Failed to realize the processor.");
            return false;
        }
        DataSink dsink = this.createDataSink(p, outML);
        if (dsink == null) {
            System.err.println("Failed to create a DataSink for the given output MediaLocator: " + outML);
            return false;
        }
        dsink.addDataSinkListener((DataSinkListener)this);
        this.fileDone = false;
        System.err.println("start processing...");
        try {
            p.start();
            dsink.start();
        }
        catch (IOException e) {
            System.err.println("IO error during processing");
            return false;
        }
        this.waitForFileDone();
        try {
            dsink.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        p.removeControllerListener((ControllerListener)this);
        System.err.println("...done processing.");
        return true;
    }

    DataSink createDataSink(Processor p, MediaLocator outML) {
        DataSink dsink;
        DataSource ds = p.getDataOutput();
        if (ds == null) {
            System.err.println("Something is really wrong: the processor does not have an output DataSource");
            return null;
        }
        try {
            System.err.println("- create DataSink for: " + outML);
            dsink = Manager.createDataSink((DataSource)ds, (MediaLocator)outML);
            dsink.open();
        }
        catch (Exception e) {
            System.err.println("Cannot create the DataSink: " + e);
            return null;
        }
        return dsink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(Processor p, int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() < state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            evt.getSourceController().stop();
            evt.getSourceController().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForFileDone() {
        Object object = this.waitFileSync;
        synchronized (object) {
            try {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSinkUpdate(DataSinkEvent evt) {
        if (evt instanceof EndOfStreamEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.waitFileSync.notifyAll();
            }
        }
        if (evt instanceof DataSinkErrorEvent) {
            Object object = this.waitFileSync;
            synchronized (object) {
                this.fileDone = true;
                this.fileSuccess = false;
                this.waitFileSync.notifyAll();
            }
        }
    }

    public static void main(String[] args) {
        MediaLocator oml;
        if (args.length == 0) {
            ImagesToVideo.prUsage();
        }
        int width = -1;
        int height = -1;
        int frameRate = 1;
        Vector<String> inputFiles = new Vector<String>();
        String outputURL = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-w")) {
                if (++i >= args.length) {
                    ImagesToVideo.prUsage();
                }
                width = new Integer(args[i]);
                continue;
            }
            if (args[i].equals("-h")) {
                if (++i >= args.length) {
                    ImagesToVideo.prUsage();
                }
                height = new Integer(args[i]);
                continue;
            }
            if (args[i].equals("-f")) {
                if (++i >= args.length) {
                    ImagesToVideo.prUsage();
                }
                frameRate = new Integer(args[i]);
                continue;
            }
            if (args[i].equals("-o")) {
                if (++i >= args.length) {
                    ImagesToVideo.prUsage();
                }
                outputURL = args[i];
                continue;
            }
            for (int j = 0; j < 120; ++j) {
                inputFiles.addElement(args[i]);
            }
        }
        if (outputURL == null || inputFiles.size() == 0) {
            ImagesToVideo.prUsage();
        }
        if (!outputURL.endsWith(".mov") && !outputURL.endsWith(".MOV")) {
            System.err.println("The output file extension should end with a .mov extension");
            ImagesToVideo.prUsage();
        }
        if (width < 0 || height < 0) {
            System.err.println("Please specify the correct image size.");
            ImagesToVideo.prUsage();
        }
        if (frameRate < 1) {
            frameRate = 1;
        }
        if ((oml = ImagesToVideo.createMediaLocator(outputURL)) == null) {
            System.err.println("Cannot build media locator from: " + outputURL);
            System.exit(0);
        }
        ImagesToVideo imageToMovie = new ImagesToVideo();
        imageToMovie.run(width, height, frameRate, inputFiles, oml);
        System.exit(0);
    }

    static void prUsage() {
        System.err.println("Usage: java JpegImagesToMovie -w <width> -h <height> -f <frame rate> -o <output URL> <input JPEG file 1> <input JPEG file 2> ...");
        System.exit(-1);
    }

    static MediaLocator createMediaLocator(String url) {
        String file;
        MediaLocator ml;
        if (url.indexOf(":") > 0 && (ml = new MediaLocator(url)) != null) {
            return ml;
        }
        if (url.startsWith(File.separator) ? (ml = new MediaLocator("file:" + url)) != null : (ml = new MediaLocator(file = "file:" + System.getProperty("user.dir") + File.separator + url)) != null) {
            return ml;
        }
        return null;
    }
}

