/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.creature;

import com.neuronrobotics.bowlerstudio.creature.IMobileBaseUI;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.svg.SVGExporter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class CadFileExporter {
    IMobileBaseUI ui;

    public CadFileExporter(IMobileBaseUI myUI) {
        this.ui = myUI;
    }

    public CadFileExporter() {
        this.ui = new IMobileBaseUI(){

            @Override
            public void setSelectedCsg(Collection<CSG> selectedCsg) {
            }

            @Override
            public void setAllCSG(Collection<CSG> toAdd, File source) {
            }

            @Override
            public void highlightException(File fileEngineRunByName, Exception ex) {
            }

            @Override
            public Set<CSG> getVisibleCSGs() {
                return null;
            }

            @Override
            public void addCSG(Collection<CSG> toAdd, File source) {
            }
        };
    }

    public ArrayList<File> generateManufacturingParts(List<CSG> totalAssembly, File baseDirForFiles) throws IOException {
        File dir;
        String fileNameWithOutExt;
        ArrayList<File> allCadStl = new ArrayList<File>();
        if (!baseDirForFiles.isDirectory() && !(baseDirForFiles = new File(fileNameWithOutExt = FilenameUtils.removeExtension((String)baseDirForFiles.getAbsolutePath()))).exists()) {
            baseDirForFiles.mkdirs();
        }
        if (!baseDirForFiles.getName().contentEquals("manufacturing")) {
            dir = new File(baseDirForFiles.getAbsolutePath() + "/manufacturing/");
            if (!dir.exists()) {
                dir.mkdirs();
            }
        } else {
            dir = baseDirForFiles;
        }
        int index = 0;
        ArrayList<CSG> svgParts = new ArrayList<CSG>();
        String svgName = null;
        String nameBase = "";
        for (CSG part : totalAssembly) {
            String name = part.getName();
            CSG manufactured = part.prepForManufacturing();
            if (manufactured == null) continue;
            manufactured.setName(part.getName());
            nameBase = dir.getAbsolutePath() + "/" + index + "-" + name;
            ++index;
            if (part.getExportFormats() == null) {
                allCadStl.add(this.makeStl(nameBase, manufactured));
                continue;
            }
            for (String format : part.getExportFormats()) {
                if (format.toLowerCase().contains("stl")) {
                    allCadStl.add(this.makeStl(nameBase, manufactured));
                    this.ui.setCsg(manufactured, null);
                }
                if (!format.toLowerCase().contains("svg")) continue;
                if (svgName == null) {
                    svgName = part.toString();
                }
                svgParts.add(manufactured);
                this.ui.setAllCSG(svgParts, null);
            }
        }
        if (svgParts.size() > 0) {
            allCadStl.add(this.makeSvg(nameBase, svgParts));
        }
        return allCadStl;
    }

    private File makeStl(String nameBase, CSG tmp) throws IOException {
        File stl = new File(nameBase + ".stl");
        FileUtil.write((Path)Paths.get(stl.getAbsolutePath(), new String[0]), (String)tmp.toStlString());
        System.out.println("Writing " + stl.getAbsolutePath());
        return stl;
    }

    private File makeSvg(String nameBase, List<CSG> currentCsg) throws IOException {
        File stl = new File(nameBase + ".svg");
        for (CSG csg : currentCsg) {
            if (csg.getSlicePlanes() != null) continue;
            csg.addSlicePlane(new Transform());
        }
        try {
            SVGExporter.export(currentCsg, (File)stl);
        }
        catch (Exception e) {
            ArrayList<CSG> movedDown = new ArrayList<CSG>();
            for (CSG csg : currentCsg) {
                CSG movez = csg.toZMin().movez((Number)-0.01);
                if (movez.getSlicePlanes() == null) {
                    movez.addSlicePlane(new Transform());
                }
                movez.setName(csg.getName());
                movedDown.add(movez);
            }
            SVGExporter.export(movedDown, (File)stl);
        }
        System.out.println("Writing " + stl.getAbsolutePath());
        return stl;
    }
}

