/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.physics;

import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.ConvexHullShape;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.util.ObjectArrayList;
import com.neuronrobotics.bowlerstudio.physics.IPhysicsManager;
import com.neuronrobotics.bowlerstudio.physics.IPhysicsUpdate;
import com.neuronrobotics.bowlerstudio.physics.PhysicsCore;
import com.neuronrobotics.bowlerstudio.physics.TransformFactory;
import com.neuronrobotics.sdk.addons.kinematics.math.TransformNR;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Vertex;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.transform.Affine;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class CSGPhysicsManager
implements IPhysicsManager {
    private RigidBody fallRigidBody;
    private final Affine ballLocation = new Affine();
    protected List<CSG> baseCSG = null;
    private Transform updateTransform = new Transform();
    private IPhysicsUpdate updateManager = null;
    private PhysicsCore core;

    public CSGPhysicsManager(List<CSG> baseCSG, Transform pose, double mass, boolean adjustCenter, PhysicsCore core) {
        this.setBaseCSG(baseCSG);
        ObjectArrayList arg0 = new ObjectArrayList();
        for (int i = 0; i < baseCSG.size(); ++i) {
            CSG back = this.loadCSGToPoints(baseCSG.get(i), adjustCenter, pose, (ObjectArrayList<Vector3f>)arg0);
            back.setManipulator(baseCSG.get(i).getManipulator());
            baseCSG.set(i, back);
        }
        ConvexHullShape fallShape = new ConvexHullShape(arg0);
        this.setup((CollisionShape)fallShape, pose, mass, core);
    }

    public CSGPhysicsManager(ArrayList<CSG> baseCSG, Vector3f start, double mass, PhysicsCore core) {
        this(baseCSG, new Transform(new Matrix4f(new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), start, 1.0f)), mass, true, core);
    }

    protected CSG loadCSGToPoints(CSG baseCSG, boolean adjustCenter, Transform pose, ObjectArrayList<Vector3f> arg0) {
        CSG finalCSG = baseCSG;
        if (adjustCenter) {
            double xcenter = baseCSG.getMaxX() / 2.0 + baseCSG.getMinX() / 2.0;
            double ycenter = baseCSG.getMaxY() / 2.0 + baseCSG.getMinY() / 2.0;
            double zcenter = baseCSG.getMaxZ() / 2.0 + baseCSG.getMinZ() / 2.0;
            TransformNR poseToMove = TransformFactory.bulletToNr(pose);
            if (baseCSG.getMaxX() < 1.0 || baseCSG.getMinX() > -1.0) {
                finalCSG = finalCSG.movex((Number)(-xcenter));
                poseToMove.translateX(xcenter);
            }
            if (baseCSG.getMaxY() < 1.0 || baseCSG.getMinY() > -1.0) {
                finalCSG = finalCSG.movey((Number)(-ycenter));
                poseToMove.translateY(ycenter);
            }
            if (baseCSG.getMaxZ() < 1.0 || baseCSG.getMinZ() > -1.0) {
                finalCSG = finalCSG.movez((Number)(-zcenter));
                poseToMove.translateZ(zcenter);
            }
            TransformFactory.nrToBullet(poseToMove, pose);
        }
        List polygons = finalCSG.getPolygons();
        for (Polygon p : polygons) {
            for (Vertex v : p.vertices) {
                arg0.add((Object)new Vector3f((float)v.getX(), (float)v.getY(), (float)v.getZ()));
            }
        }
        return finalCSG;
    }

    public static CSG getBoundingBox(CSG incoming) {
        return new Cube(-incoming.getMinX() + incoming.getMaxX(), -incoming.getMinY() + incoming.getMaxY(), -incoming.getMinZ() + incoming.getMaxZ()).toCSG().toXMax().movex((Number)incoming.getMaxX()).toYMax().movey((Number)incoming.getMaxY()).toZMax().movez((Number)incoming.getMaxZ());
    }

    public void setup(CollisionShape fallShape, Transform pose, double mass, PhysicsCore core) {
        this.setCore(core);
        System.out.println("Starting Object at " + TransformFactory.bulletToNr(pose));
        DefaultMotionState fallMotionState = new DefaultMotionState(pose);
        Vector3f fallInertia = new Vector3f(0.0f, 0.0f, 0.0f);
        fallShape.calculateLocalInertia((float)mass, fallInertia);
        RigidBodyConstructionInfo fallRigidBodyCI = new RigidBodyConstructionInfo((float)mass, (MotionState)fallMotionState, fallShape, fallInertia);
        fallRigidBodyCI.additionalDamping = true;
        this.setFallRigidBody(new RigidBody(fallRigidBodyCI));
    }

    @Override
    public void update(float timeStep) {
        this.fallRigidBody.getMotionState().getWorldTransform(this.updateTransform);
        if (this.getUpdateManager() != null) {
            this.getUpdateManager().update(timeStep);
        }
    }

    @Override
    public RigidBody getFallRigidBody() {
        return this.fallRigidBody;
    }

    public void setFallRigidBody(RigidBody fallRigidBody) {
        this.fallRigidBody = fallRigidBody;
    }

    @Override
    public List<CSG> getBaseCSG() {
        return this.baseCSG;
    }

    public void setBaseCSG(List<CSG> baseCSG) {
        for (CSG c : baseCSG) {
            c.setManipulator(this.getRigidBodyLocation());
        }
        this.baseCSG = baseCSG;
    }

    @Override
    public Transform getUpdateTransform() {
        return this.updateTransform;
    }

    @Override
    public Affine getRigidBodyLocation() {
        return this.ballLocation;
    }

    public IPhysicsUpdate getUpdateManager() {
        return this.updateManager;
    }

    public void setUpdateManager(IPhysicsUpdate updateManager) {
        this.updateManager = updateManager;
    }

    public PhysicsCore getCore() {
        return this.core;
    }

    public void setCore(PhysicsCore core) {
        this.core = core;
    }
}

