/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.physics;

import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.DbvtBroadphase;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.StaticPlaneShape;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import com.neuronrobotics.bowlerstudio.physics.HingeCSGPhysicsManager;
import com.neuronrobotics.bowlerstudio.physics.IPhysicsManager;
import com.neuronrobotics.bowlerstudio.physics.TransformFactory;
import com.neuronrobotics.bowlerstudio.physics.VehicleCSGPhysicsManager;
import com.neuronrobotics.bowlerstudio.physics.WheelCSGPhysicsManager;
import com.neuronrobotics.sdk.util.ThreadUtil;
import eu.mihosoft.vrl.v3d.CSG;
import java.util.ArrayList;
import javafx.application.Platform;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class PhysicsCore {
    private BroadphaseInterface broadphase = new DbvtBroadphase();
    private DefaultCollisionConfiguration collisionConfiguration = new DefaultCollisionConfiguration();
    private CollisionDispatcher dispatcher = new CollisionDispatcher((CollisionConfiguration)this.collisionConfiguration);
    private SequentialImpulseConstraintSolver solver = new SequentialImpulseConstraintSolver();
    private DiscreteDynamicsWorld dynamicsWorld = new DiscreteDynamicsWorld((Dispatcher)this.dispatcher, this.broadphase, (ConstraintSolver)this.solver, (CollisionConfiguration)this.collisionConfiguration);
    private CollisionShape groundShape = null;
    private ArrayList<IPhysicsManager> objects = new ArrayList();
    private RigidBody groundRigidBody;
    private boolean runEngine = false;
    private int msTime = 16;
    private Thread physicsThread = null;
    private int simulationSubSteps = 5;
    private float lin_damping;
    private float ang_damping;
    private float linearSleepThreshhold;
    private float angularSleepThreshhold;
    private float deactivationTime;

    public PhysicsCore() throws Exception {
        this.getDynamicsWorld().setGravity(new Vector3f(0.0f, 0.0f, -588.0f));
        this.setGroundShape((CollisionShape)new StaticPlaneShape(new Vector3f(0.0f, 0.0f, 10.0f), 1.0f));
    }

    public BroadphaseInterface getBroadphase() {
        return this.broadphase;
    }

    public void setBroadphase(BroadphaseInterface broadphase) {
        this.broadphase = broadphase;
    }

    public DefaultCollisionConfiguration getCollisionConfiguration() {
        return this.collisionConfiguration;
    }

    public void setCollisionConfiguration(DefaultCollisionConfiguration collisionConfiguration) {
        this.collisionConfiguration = collisionConfiguration;
    }

    public CollisionDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(CollisionDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public SequentialImpulseConstraintSolver getSolver() {
        return this.solver;
    }

    public void setSolver(SequentialImpulseConstraintSolver solver) {
        this.solver = solver;
    }

    public DiscreteDynamicsWorld getDynamicsWorld() {
        return this.dynamicsWorld;
    }

    public void setDynamicsWorld(DiscreteDynamicsWorld dynamicsWorld) {
        this.dynamicsWorld = dynamicsWorld;
    }

    public CollisionShape getGroundShape() {
        return this.groundShape;
    }

    public void setGroundShape(CollisionShape cs) {
        if (this.groundRigidBody != null) {
            this.getDynamicsWorld().removeRigidBody(this.groundRigidBody);
        }
        this.groundShape = cs;
        DefaultMotionState groundMotionState = new DefaultMotionState(new Transform(new Matrix4f(new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f), 1.0f)));
        RigidBodyConstructionInfo groundRigidBodyCI = new RigidBodyConstructionInfo(0.0f, (MotionState)groundMotionState, this.groundShape, new Vector3f(0.0f, 0.0f, 0.0f));
        this.groundRigidBody = new RigidBody(groundRigidBodyCI);
        this.dynamicsWorld.addRigidBody(this.groundRigidBody);
    }

    public ArrayList<IPhysicsManager> getPhysicsObjects() {
        return this.objects;
    }

    public void setDamping(float lin_damping, float ang_damping) {
        this.lin_damping = lin_damping;
        this.ang_damping = ang_damping;
        for (IPhysicsManager m : this.getPhysicsObjects()) {
            m.getFallRigidBody().setDamping(lin_damping, ang_damping);
        }
    }

    public void setSleepingThresholds(float linearSleepThreshhold, float angularSleepThreshhold) {
        this.linearSleepThreshhold = linearSleepThreshhold;
        this.angularSleepThreshhold = angularSleepThreshhold;
        for (IPhysicsManager m : this.getPhysicsObjects()) {
            m.getFallRigidBody().setSleepingThresholds(linearSleepThreshhold, angularSleepThreshhold);
        }
    }

    public void setDeactivationTime(float deactivationTime) {
        this.deactivationTime = deactivationTime;
        for (IPhysicsManager m : this.getPhysicsObjects()) {
            m.getFallRigidBody().setDeactivationTime(deactivationTime);
        }
    }

    public void setObjects(ArrayList<IPhysicsManager> objects) {
        this.objects = objects;
    }

    public void startPhysicsThread(int ms) {
        this.msTime = ms;
        if (this.physicsThread == null) {
            this.runEngine = true;
            this.physicsThread = new Thread(() -> {
                while (this.runEngine) {
                    try {
                        long start = System.currentTimeMillis();
                        this.stepMs(this.msTime);
                        long took = System.currentTimeMillis() - start;
                        if (took < (long)this.msTime) {
                            ThreadUtil.wait((int)((int)((long)this.msTime - took)));
                            continue;
                        }
                        System.out.println("Real time physics broken: " + took);
                    }
                    catch (Exception E) {
                        E.printStackTrace();
                    }
                }
            });
            this.physicsThread.start();
        }
    }

    public ArrayList<CSG> getCsgFromEngine() {
        ArrayList<CSG> csg = new ArrayList<CSG>();
        for (IPhysicsManager o : this.getPhysicsObjects()) {
            for (CSG c : o.getBaseCSG()) {
                csg.add(c);
            }
        }
        return csg;
    }

    public void stopPhysicsThread() {
        this.physicsThread = null;
        this.runEngine = false;
    }

    public void step(float timeStep) {
        long startTime = System.currentTimeMillis();
        this.getDynamicsWorld().stepSimulation(timeStep, this.getSimulationSubSteps());
        if ((float)(System.currentTimeMillis() - startTime) / 1000.0f > timeStep) {
            // empty if block
        }
        for (IPhysicsManager o : this.getPhysicsObjects()) {
            o.update(timeStep);
        }
        Platform.runLater(() -> {
            for (IPhysicsManager o : this.getPhysicsObjects()) {
                try {
                    TransformFactory.bulletToAffine(o.getRigidBodyLocation(), o.getUpdateTransform());
                }
                catch (Exception exception) {}
            }
        });
    }

    public void stepMs(double timeStep) {
        this.step((float)(timeStep / 1000.0));
    }

    public void add(IPhysicsManager manager) {
        if (!this.getPhysicsObjects().contains(manager)) {
            this.getPhysicsObjects().add(manager);
            if (!WheelCSGPhysicsManager.class.isInstance(manager) && !VehicleCSGPhysicsManager.class.isInstance(manager)) {
                this.getDynamicsWorld().addRigidBody(manager.getFallRigidBody());
            }
            if (HingeCSGPhysicsManager.class.isInstance(manager) && ((HingeCSGPhysicsManager)manager).getConstraint() != null) {
                this.getDynamicsWorld().addConstraint((TypedConstraint)((HingeCSGPhysicsManager)manager).getConstraint(), true);
            }
            if (VehicleCSGPhysicsManager.class.isInstance(manager)) {
                this.getDynamicsWorld().addVehicle(((VehicleCSGPhysicsManager)manager).getVehicle());
            }
        }
    }

    public void remove(IPhysicsManager manager) {
        if (this.getPhysicsObjects().contains(manager)) {
            this.getPhysicsObjects().remove(manager);
            if (!WheelCSGPhysicsManager.class.isInstance(manager) && !VehicleCSGPhysicsManager.class.isInstance(manager)) {
                this.getDynamicsWorld().removeRigidBody(manager.getFallRigidBody());
            }
            if (HingeCSGPhysicsManager.class.isInstance(manager) && ((HingeCSGPhysicsManager)manager).getConstraint() != null) {
                this.getDynamicsWorld().removeConstraint((TypedConstraint)((HingeCSGPhysicsManager)manager).getConstraint());
            }
            if (VehicleCSGPhysicsManager.class.isInstance(manager)) {
                this.getDynamicsWorld().removeVehicle(((VehicleCSGPhysicsManager)manager).getVehicle());
            }
        }
    }

    public void clear() {
        this.stopPhysicsThread();
        ThreadUtil.wait((int)(this.msTime * 2));
        for (IPhysicsManager manager : this.getPhysicsObjects()) {
            if (!WheelCSGPhysicsManager.class.isInstance(manager) && !VehicleCSGPhysicsManager.class.isInstance(manager)) {
                this.getDynamicsWorld().removeRigidBody(manager.getFallRigidBody());
            }
            if (HingeCSGPhysicsManager.class.isInstance(manager) && ((HingeCSGPhysicsManager)manager).getConstraint() != null) {
                this.getDynamicsWorld().removeConstraint((TypedConstraint)((HingeCSGPhysicsManager)manager).getConstraint());
            }
            if (!VehicleCSGPhysicsManager.class.isInstance(manager)) continue;
            this.getDynamicsWorld().removeVehicle(((VehicleCSGPhysicsManager)manager).getVehicle());
        }
        this.getPhysicsObjects().clear();
    }

    public int getSimulationSubSteps() {
        return this.simulationSubSteps;
    }

    public float getDeactivationTime() {
        return this.deactivationTime;
    }

    public void setSimulationSubSteps(int simpulationSubSteps) {
        this.simulationSubSteps = simpulationSubSteps;
    }

    public float getLin_damping() {
        return this.lin_damping;
    }

    public float getAng_damping() {
        return this.ang_damping;
    }

    public float getLinearSleepThreshhold() {
        return this.linearSleepThreshhold;
    }

    public float getAngularSleepThreshhold() {
        return this.angularSleepThreshhold;
    }
}

