/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.creature;

import com.neuronrobotics.bowlerstudio.creature.MobileBaseCadManager;
import eu.mihosoft.vrl.v3d.CSG;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public interface IMobileBaseUI {
    public void setAllCSG(Collection<CSG> var1, File var2);

    public void addCSG(Collection<CSG> var1, File var2);

    public void highlightException(File var1, Exception var2);

    public Set<CSG> getVisibleCSGs();

    public void setSelectedCsg(Collection<CSG> var1);

    default public void selectCsgByFile(File script, int lineNumber) {
        ArrayList<CSG> objsFromScriptLine = new ArrayList<CSG>();
        for (CSG checker : this.getVisibleCSGs()) {
            for (String trace : checker.getCreationEventStackTraceList()) {
                int num;
                String[] traceParts = trace.split(":");
                if (!traceParts[0].trim().toLowerCase().contains(script.getName().toLowerCase().trim()) || (num = Integer.parseInt(traceParts[1].trim())) != lineNumber) continue;
                objsFromScriptLine.add(checker);
            }
        }
        if (objsFromScriptLine.size() > 0) {
            this.setSelectedCsg(objsFromScriptLine);
        }
    }

    default public void setCsg(CSG toAdd, File source) {
        this.setAllCSG(Collections.singletonList(toAdd), source);
    }

    default public void setCsg(List<CSG> toAdd) {
        this.setAllCSG(toAdd, null);
    }

    default public void setCsg(CSG toAdd) {
        this.setAllCSG(Collections.singletonList(toAdd), null);
    }

    default public void setCsg(MobileBaseCadManager thread, File cadScript) {
        this.setAllCSG(thread.getAllCad(), cadScript);
    }

    default public void addCsg(CSG toAdd, File source) {
        this.addCSG(Collections.singletonList(toAdd), source);
    }
}

