/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.physics;

import Jama.Matrix;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.HingeConstraint;
import com.bulletphysics.linearmath.Transform;
import com.neuronrobotics.bowlerstudio.physics.CSGPhysicsManager;
import com.neuronrobotics.bowlerstudio.physics.HingeCSGPhysicsManager;
import com.neuronrobotics.bowlerstudio.physics.IPhysicsUpdate;
import com.neuronrobotics.bowlerstudio.physics.PhysicsCore;
import com.neuronrobotics.bowlerstudio.physics.PhysicsEngine;
import com.neuronrobotics.bowlerstudio.physics.TransformFactory;
import com.neuronrobotics.sdk.addons.kinematics.AbstractLink;
import com.neuronrobotics.sdk.addons.kinematics.DHLink;
import com.neuronrobotics.sdk.addons.kinematics.DHParameterKinematics;
import com.neuronrobotics.sdk.addons.kinematics.ILinkListener;
import com.neuronrobotics.sdk.addons.kinematics.LinkConfiguration;
import com.neuronrobotics.sdk.addons.kinematics.MobileBase;
import com.neuronrobotics.sdk.addons.kinematics.imu.IMU;
import com.neuronrobotics.sdk.addons.kinematics.imu.IMUUpdate;
import com.neuronrobotics.sdk.addons.kinematics.math.RotationNR;
import com.neuronrobotics.sdk.addons.kinematics.math.TransformNR;
import com.neuronrobotics.sdk.common.IClosedLoopController;
import com.neuronrobotics.sdk.pid.PIDLimitEvent;
import com.neuronrobotics.sdk.util.ThreadUtil;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.HullUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.paint.Color;
import javafx.scene.transform.Affine;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class MobileBasePhysicsManager {
    public static final float PhysicsGravityScalar = 6.0f;
    private HashMap<LinkConfiguration, ArrayList<CSG>> simplecad;
    private float lift = 0.0f;
    private ArrayList<ILinkListener> linkListeners = new ArrayList();
    public static final float LIFT_EPS = (float)Math.toRadians(0.1);

    private IPhysicsUpdate getUpdater(final RigidBody body, final IMU base) {
        return new IPhysicsUpdate(){
            Vector3f oldavelocity = new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f oldvelocity = new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f gravity = new Vector3f();
            private Quat4f orentation = new Quat4f();
            Transform gravTrans = new Transform();
            Transform orentTrans = new Transform();
            Vector3f avelocity = new Vector3f();
            Vector3f velocity = new Vector3f();

            @Override
            public void update(float timeStep) {
                body.getAngularVelocity(this.avelocity);
                body.getLinearVelocity(this.velocity);
                body.getGravity(this.gravity);
                body.getOrientation(this.orentation);
                TransformFactory.nrToBullet(new TransformNR((double)this.gravity.x, (double)this.gravity.y, (double)this.gravity.z, new RotationNR()), this.gravTrans);
                TransformFactory.nrToBullet(new TransformNR(0.0, 0.0, 0.0, (double)this.orentation.w, (double)this.orentation.x, (double)this.orentation.y, (double)this.orentation.z), this.orentTrans);
                this.orentTrans.inverse();
                this.orentTrans.mul(this.gravTrans);
                Double rotxAcceleration = (this.oldavelocity.x - this.avelocity.x) / timeStep;
                Double rotyAcceleration = (this.oldavelocity.y - this.avelocity.y) / timeStep;
                Double rotzAcceleration = (this.oldavelocity.z - this.avelocity.z) / timeStep;
                Double xAcceleration = (double)((this.oldvelocity.x - this.velocity.x) / timeStep / 6.0f) + (double)(this.orentTrans.origin.x / 6.0f);
                Double yAcceleration = (double)((this.oldvelocity.y - this.velocity.y) / timeStep / 6.0f) + (double)(this.orentTrans.origin.y / 6.0f);
                Double zAcceleration = (double)((this.oldvelocity.z - this.velocity.z) / timeStep / 6.0f) + (double)(this.orentTrans.origin.z / 6.0f);
                base.setVirtualState(new IMUUpdate(xAcceleration, yAcceleration, zAcceleration, rotxAcceleration, rotyAcceleration, rotzAcceleration));
                this.oldavelocity.set((Tuple3f)this.avelocity);
                this.oldvelocity.set((Tuple3f)this.velocity);
            }
        };
    }

    public MobileBasePhysicsManager(MobileBase base, ArrayList<CSG> baseCad, HashMap<LinkConfiguration, ArrayList<CSG>> simplecad) {
        this(base, baseCad, simplecad, PhysicsEngine.get());
    }

    public MobileBasePhysicsManager(MobileBase base, final ArrayList<CSG> baseCad, HashMap<LinkConfiguration, ArrayList<CSG>> simplecad, PhysicsCore core) {
        this.simplecad = simplecad;
        double minz = 0.0;
        double Maxz = 0.0;
        for (DHParameterKinematics dh : base.getAllDHChains()) {
            if (!(dh.getCurrentTaskSpaceTransform().getZ() < minz)) continue;
            minz = dh.getCurrentTaskSpaceTransform().getZ();
        }
        for (CSG c : baseCad) {
            if (c.getMinZ() < minz) {
                minz = c.getMinZ();
            }
            if (!(c.getMaxZ() > Maxz)) continue;
            Maxz = c.getMaxZ();
        }
        final Transform start = new Transform();
        base.setFiducialToGlobalTransform(new TransformNR());
        TransformFactory.nrToBullet(base.getFiducialToGlobalTransform(), start);
        start.origin.z = (float)((double)start.origin.z - minz + (double)this.lift);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TransformFactory.bulletToAffine(((CSG)baseCad.get(0)).getManipulator(), start);
            }
        });
        ArrayList<Vector3d> points = new ArrayList<Vector3d>();
        for (DHParameterKinematics leg : base.getAllDHChains()) {
            TransformNR limbRoot = leg.getRobotToFiducialTransform();
            points.add(new Vector3d(limbRoot.getX(), limbRoot.getY(), limbRoot.getZ()));
            points.add(new Vector3d(limbRoot.getX(), limbRoot.getY(), Maxz));
        }
        CSG collisionBod = HullUtil.hull(points);
        CSGPhysicsManager baseManager = new CSGPhysicsManager(Arrays.asList(collisionBod), start, base.getMassKg(), false, core);
        baseManager.setBaseCSG(baseCad);
        RigidBody body = baseManager.getFallRigidBody();
        baseManager.setUpdateManager(this.getUpdater(body, base.getImu()));
        body.setWorldTransform(start);
        core.getDynamicsWorld().setGravity(new Vector3f(0.0f, 0.0f, -588.0f));
        core.add(baseManager);
        for (int j = 0; j < base.getAllDHChains().size(); ++j) {
            DHParameterKinematics dh = (DHParameterKinematics)base.getAllDHChains().get(j);
            TransformNR limbRoot = dh.getRobotToFiducialTransform();
            RigidBody lastLink = body;
            Matrix previousStep = null;
            dh.forwardKinematics(dh.getCurrentJointSpaceVector());
            ArrayList cachedStart = dh.getDhChain().getCachedChain();
            List cached = cachedStart.stream().collect(Collectors.toList());
            for (int i = 0; i < dh.getNumberOfLinks() && i < cached.size(); ++i) {
                LinkConfiguration conf = dh.getLinkConfiguration(i);
                DHLink l = (DHLink)dh.getDhChain().getLinks().get(i);
                ArrayList<CSG> thisLinkCad = simplecad.get(conf);
                if (thisLinkCad == null || thisLinkCad.size() <= 0) continue;
                Matrix step = conf.isPrismatic() ? l.DhStepInversePrismatic(0.0) : l.DhStepInverseRotory(Math.toRadians(0.0));
                AbstractLink abstractLink = dh.getAbstractLink(i);
                final Affine manipulator = new Affine();
                final TransformNR localLink = i > 0 ? (TransformNR)cached.get(i - 1) : limbRoot.copy();
                localLink.translateZ((double)this.lift);
                Transform linkLoc = new Transform();
                TransformFactory.nrToBullet(localLink, linkLoc);
                linkLoc.origin.z = (float)((double)linkLoc.origin.z - minz + (double)this.lift);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TransformFactory.nrToAffine((TransformNR)localLink, (Affine)manipulator);
                    }
                });
                ThreadUtil.wait((int)16);
                double mass = conf.getMassKg();
                ArrayList<CSG> outCad = new ArrayList<CSG>();
                ArrayList<CSG> collisions = new ArrayList<CSG>();
                for (int x = 0; x < thisLinkCad.size(); ++x) {
                    Color color = thisLinkCad.get(x).getColor();
                    CSG cad = thisLinkCad.get(x);
                    CSG tmp = CSGPhysicsManager.getBoundingBox(cad);
                    outCad.add(cad.transformed(TransformFactory.nrToCSG(new TransformNR(step).inverse())));
                    outCad.get(x).setManipulator(manipulator);
                    outCad.get(x).setColor(color);
                    collisions.add(tmp.transformed(TransformFactory.nrToCSG(new TransformNR(step).inverse())));
                    collisions.get(x).setManipulator(manipulator);
                    collisions.get(x).setColor(color);
                }
                final HingeCSGPhysicsManager hingePhysicsManager = new HingeCSGPhysicsManager(collisions, linkLoc, mass, core);
                hingePhysicsManager.setBaseCSG(outCad);
                HingeCSGPhysicsManager.setMuscleStrength(1000000.0f);
                RigidBody linkSection = hingePhysicsManager.getFallRigidBody();
                hingePhysicsManager.setUpdateManager(this.getUpdater(linkSection, abstractLink.getImu()));
                linkSection.setActivationState(4);
                Transform localA = new Transform();
                Transform localB = new Transform();
                localA.setIdentity();
                localB.setIdentity();
                if (i == 0) {
                    TransformFactory.nrToBullet(dh.forwardOffset(new TransformNR()), localA);
                } else {
                    TransformFactory.nrToBullet(new TransformNR(previousStep.inverse()), localA);
                }
                TransformFactory.nrToBullet(new TransformNR(), localB);
                previousStep = step;
                HingeConstraint joint6DOF = new HingeConstraint(lastLink, linkSection, localA, localB);
                joint6DOF.setLimit(-((float)Math.toRadians(abstractLink.getMinEngineeringUnits())), -((float)Math.toRadians(abstractLink.getMaxEngineeringUnits())));
                lastLink = linkSection;
                hingePhysicsManager.setConstraint(joint6DOF);
                if (!conf.isPassive()) {
                    ILinkListener ll = new ILinkListener(){

                        public void onLinkPositionUpdate(AbstractLink source, double engineeringUnitsValue) {
                            hingePhysicsManager.setTarget(Math.toRadians(-engineeringUnitsValue));
                        }

                        public void onLinkLimit(AbstractLink source, PIDLimitEvent event) {
                        }
                    };
                    hingePhysicsManager.setController(new IClosedLoopController(){

                        public double compute(double currentState, double target, double seconds) {
                            double error = target - currentState;
                            return error / seconds * (seconds * 10.0);
                        }
                    });
                    abstractLink.addLinkListener(ll);
                    this.linkListeners.add(ll);
                }
                abstractLink.getCurrentPosition();
                core.add(hingePhysicsManager);
                linkSection.setWorldTransform(linkLoc);
            }
        }
    }
}

