/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.physics;

import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.vehicle.DefaultVehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.dynamics.vehicle.VehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.VehicleTuning;
import com.bulletphysics.linearmath.Transform;
import com.neuronrobotics.bowlerstudio.physics.CSGPhysicsManager;
import com.neuronrobotics.bowlerstudio.physics.PhysicsCore;
import eu.mihosoft.vrl.v3d.CSG;
import java.util.ArrayList;

public class VehicleCSGPhysicsManager
extends CSGPhysicsManager {
    private VehicleTuning tuning = new VehicleTuning();
    public VehicleRaycaster vehicleRayCaster;
    private RaycastVehicle vehicle;

    public VehicleCSGPhysicsManager(ArrayList<CSG> baseCSG, Transform pose, double mass, boolean adjustCenter, PhysicsCore core) {
        super(baseCSG, pose, mass, adjustCenter, core);
        this.vehicleRayCaster = new DefaultVehicleRaycaster((DynamicsWorld)core.getDynamicsWorld());
        this.setVehicle(new RaycastVehicle(this.getTuning(), this.getFallRigidBody(), this.vehicleRayCaster));
    }

    @Override
    public void update(float timeStep) {
        this.getFallRigidBody().getMotionState().getWorldTransform(this.getUpdateTransform());
        if (this.getUpdateManager() != null) {
            this.getUpdateManager().update(timeStep);
        }
        this.vehicle.updateVehicle(timeStep);
    }

    public RaycastVehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(RaycastVehicle vehicle) {
        this.vehicle = vehicle;
    }

    public VehicleTuning getTuning() {
        return this.tuning;
    }

    public void setTuning(VehicleTuning tuning) {
        this.tuning = tuning;
    }
}

