/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio;

import com.neuronrobotics.bowlerstudio.scripting.ScriptingEngine;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jline.ConsoleReader;
import jline.Terminal;

public class BowlerKernel {
    private static final String CSG = null;
    private static File historyFile = new File(ScriptingEngine.getWorkspace().getAbsolutePath() + "/bowler.history");

    private static void fail() {
        System.err.println("Usage: \r\njava -jar BowlerScriptKernel.jar -s <file 1> .. <file n> # This will load one script after the next ");
        System.err.println("java -jar BowlerScriptKernel.jar -p <file 1> .. <file n> # This will load one script then take the list of objects returned and pss them to the next script as its 'args' variable ");
        System.err.println("java -jar BowlerScriptKernel.jar -r <Groovy Jython or Clojure> (Optional)(-s or -p)<file 1> .. <file n> # This will start a shell in the requested langauge and run the files provided. ");
        System.exit(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        String groovy;
        if (args.length == 0) {
            BowlerKernel.fail();
        }
        boolean startLoadingScripts = false;
        Object ret = null;
        for (String string : args) {
            if (startLoadingScripts) {
                try {
                    ret = ScriptingEngine.inlineFileScriptRun(new File(string), null);
                }
                catch (Error e2) {
                    e2.printStackTrace();
                    BowlerKernel.fail();
                }
            }
            if (!string.contains("script") && !string.contains("-s")) continue;
            startLoadingScripts = true;
        }
        startLoadingScripts = false;
        for (String string : args) {
            if (startLoadingScripts) {
                try {
                    ret = ScriptingEngine.inlineFileScriptRun(new File(string), (ArrayList)ret);
                }
                catch (Error e3) {
                    e3.printStackTrace();
                    BowlerKernel.fail();
                }
            }
            if (!string.contains("pipe") && !string.contains("-p")) continue;
            startLoadingScripts = true;
        }
        boolean runShell = false;
        String shellTypeStorage = groovy = "Groovy";
        for (String s : args) {
            if (runShell) {
                try {
                    shellTypeStorage = s;
                }
                catch (Exception e4) {
                    shellTypeStorage = groovy;
                }
                break;
            }
            if (!s.contains("repl") && !s.contains("-r")) continue;
            runShell = true;
        }
        System.out.println("Starting Bowler REPL in langauge: " + shellTypeStorage);
        if (!Terminal.getTerminal().isSupported()) {
            System.out.println("Terminal not supported " + Terminal.getTerminal());
        }
        final ConsoleReader consoleReader = new ConsoleReader();
        consoleReader.addTriggeredAction('\u0003', e -> System.exit(0));
        if (!historyFile.exists()) {
            historyFile.createNewFile();
            consoleReader.getHistory().addToHistory("println SDKBuildInfo.getVersion()");
            consoleReader.getHistory().addToHistory("for(int i=0;i<100;i++) { println dyio.getValue(0) }");
            consoleReader.getHistory().addToHistory("dyio.setValue(0,128)");
            consoleReader.getHistory().addToHistory("println dyio.getValue(0)");
            consoleReader.getHistory().addToHistory("ScriptingEngine.inlineGistScriptRun(\"d4312a0787456ec27a2a\", \"helloWorld.groovy\" , null)");
            consoleReader.getHistory().addToHistory("DeviceManager.addConnection(new DyIO(ConnectionDialog.promptConnection()),\"dyio\")");
            consoleReader.getHistory().addToHistory("DeviceManager.addConnection(new DyIO(new SerialConnection(\"/dev/DyIO0\")),\"dyio\")");
            consoleReader.getHistory().addToHistory("BowlerKernel.speak(\"Text to speech works like this\")");
            consoleReader.getHistory().addToHistory("println \"Hello world!\"");
            BowlerKernel.writeHistory(consoleReader.getHistory().getHistoryList());
        } else {
            ArrayList<String> history = BowlerKernel.loadHistory();
            for (String h : history) {
                consoleReader.getHistory().addToHistory(h);
            }
        }
        consoleReader.setBellEnabled(false);
        consoleReader.setDebug(new PrintWriter(new FileWriter("writer.debug", true)));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BowlerKernel.writeHistory(consoleReader.getHistory().getHistoryList());
            }
        });
        try {
            String line;
            block17: while ((line = consoleReader.readLine("Bowler " + shellTypeStorage + "> ")) != null) {
                if (line.equalsIgnoreCase("quit")) return;
                if (line.equalsIgnoreCase("exit")) {
                    return;
                }
                if (line.equalsIgnoreCase("history") || line.equalsIgnoreCase("h")) {
                    List h = consoleReader.getHistory().getHistoryList();
                    Iterator iterator = h.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block17;
                        String s = (String)iterator.next();
                        System.out.println(s);
                    }
                }
                if (line.startsWith("shellType")) {
                    try {
                        shellTypeStorage = line.split(" ")[1];
                    }
                    catch (Exception e5) {
                        shellTypeStorage = groovy;
                    }
                    continue;
                }
                try {
                    ret = ScriptingEngine.inlineScriptStringRun(line, null, shellTypeStorage);
                    if (ret == null) continue;
                    System.out.println(ret);
                }
                catch (Error e6) {
                    e6.printStackTrace();
                }
                catch (Exception e7) {
                    e7.printStackTrace();
                }
            }
            return;
        }
        catch (Exception e8) {
            e8.printStackTrace();
        }
    }

    public static ArrayList<String> loadHistory() throws IOException {
        ArrayList<String> history = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(historyFile));
        String line = null;
        while ((line = br.readLine()) != null) {
            history.add(line);
        }
        br.close();
        return history;
    }

    public static void writeHistory(List<String> history) {
        System.out.println("Saving history");
        try {
            FileOutputStream fos = new FileOutputStream(historyFile);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            for (String s : history) {
                bw.write(s);
                bw.newLine();
            }
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int speak(String msg) {
        return BowlerKernel.speak(msg, 175.0, 120.0, 41.0, 1.0, 1.0);
    }

    public static int speak(String msg, Double rate, Double pitch, Double range, Double shift, Double volume) {
        System.setProperty("freetts.voices", "com.sun.speech.freetts.en.us.cmu_us_kal.KevinVoiceDirectory");
        VoiceManager voiceManager = VoiceManager.getInstance();
        Voice voice = voiceManager.getVoice("kevin16");
        System.out.println("Rate " + rate);
        System.out.println("Pitch hertz " + pitch);
        System.out.println("PitchRange " + range);
        System.out.println("PitchShift " + shift);
        System.out.println("Volume " + volume);
        if (voice != null) {
            voice.setRate(rate.floatValue());
            voice.setPitch(pitch.floatValue());
            voice.setPitchRange(range.floatValue());
            voice.setPitchShift(shift.floatValue());
            voice.setVolume(volume.floatValue());
            voice.allocate();
            voice.speak(msg);
            voice.deallocate();
        } else {
            System.out.println("All voices available:");
            Voice[] voices = voiceManager.getVoices();
            for (int i = 0; i < voices.length; ++i) {
                System.out.println("    " + voices[i].getName() + " (" + voices[i].getDomain() + " domain)");
            }
        }
        return 0;
    }

    static {
        historyFile = new File(ScriptingEngine.getWorkspace().getAbsolutePath() + "/bowler.history");
        ArrayList<String> history = new ArrayList<String>();
        if (!historyFile.exists()) {
            try {
                historyFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            history.add("println SDKBuildInfo.getVersion()");
            history.add("for(int i=0;i<1000000;i++) { println dyio.getValue(0) }");
            history.add("dyio.setValue(0,128)");
            history.add("println dyio.getValue(0)");
            history.add("ScriptingEngine.inlineGistScriptRun(\"d4312a0787456ec27a2a\", \"helloWorld.groovy\" , null)");
            history.add("DeviceManager.addConnection(new DyIO(ConnectionDialog.promptConnection()),\"dyio\")");
            history.add("DeviceManager.addConnection(new DyIO(new SerialConnection(\"/dev/DyIO0\")),\"dyio\")");
            history.add("shellType Clojure #Switches shell to Clojure");
            history.add("shellType Jython #Switches shell to Python");
            history.add("shellType Groovy #Switches shell to Groovy/Java");
            history.add("println \"Hello world!\"");
            BowlerKernel.writeHistory(history);
        }
    }
}

