/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.assets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.neuronrobotics.bowlerstudio.scripting.ScriptingEngine;
import java.io.File;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class ConfigurationDatabase {
    private static final String repo = "BowlerStudioConfiguration";
    private static final String HTTPS_GITHUB_COM_NEURON_ROBOTICS_BOWLER_STUDIO_CONFIGURATION_GIT = "https://github.com/CommonWealthRobotics/BowlerStudioConfiguration.git";
    private static String gitSource = null;
    private static String dbFile = "database.json";
    private static boolean checked;
    private static HashMap<String, HashMap<String, Object>> database;
    private static final Type TT_mapStringString;
    private static Gson gson;

    public static Object getObject(String paramsKey, String objectKey, Object defaultValue) {
        if (ConfigurationDatabase.getParamMap(paramsKey).get(objectKey) == null) {
            System.err.println("Cant find: " + paramsKey + ":" + objectKey);
            ConfigurationDatabase.setObject(paramsKey, objectKey, defaultValue);
        }
        return ConfigurationDatabase.getParamMap(paramsKey).get(objectKey);
    }

    public static HashMap<String, Object> getParamMap(String paramsKey) {
        if (ConfigurationDatabase.getDatabase().get(paramsKey) == null) {
            ConfigurationDatabase.getDatabase().put(paramsKey, new HashMap());
        }
        return ConfigurationDatabase.getDatabase().get(paramsKey);
    }

    public static Object setObject(String paramsKey, String objectKey, Object value) {
        return ConfigurationDatabase.getParamMap(paramsKey).put(objectKey, value);
    }

    public static Object removeObject(String paramsKey, String objectKey) {
        return ConfigurationDatabase.getParamMap(paramsKey).remove(objectKey);
    }

    public static void save() {
        String writeOut = null;
        ConfigurationDatabase.getDatabase();
        writeOut = gson.toJson(database, TT_mapStringString);
        try {
            ScriptingEngine.pushCodeToGit(ConfigurationDatabase.getGitSource(), ScriptingEngine.getFullBranch(ConfigurationDatabase.getGitSource()), ConfigurationDatabase.getDbFile(), writeOut, "Saving database");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<String, HashMap<String, Object>> getDatabase() {
        if (database != null) {
            return database;
        }
        try {
            database = (HashMap)ScriptingEngine.inlineFileScriptRun(ConfigurationDatabase.loadFile(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (database == null) {
            database = new HashMap();
        }
        return database;
    }

    public static File loadFile() throws Exception {
        return ScriptingEngine.fileFromGit(ConfigurationDatabase.getGitSource(), ConfigurationDatabase.getDbFile());
    }

    public static String getGitSource() throws Exception {
        if (!checked) {
            checked = true;
            if (ScriptingEngine.hasNetwork() && ScriptingEngine.isLoginSuccess()) {
                ScriptingEngine.setAutoupdate(true);
                GitHub github = ScriptingEngine.getGithub();
                GHMyself self = github.getMyself();
                Map myPublic = self.getAllRepositories();
                for (Map.Entry entry : myPublic.entrySet()) {
                    if (!((String)entry.getKey()).contentEquals(repo) || !((GHRepository)entry.getValue()).getOwnerName().equals(self.getName())) continue;
                    GHRepository ghrepo = (GHRepository)entry.getValue();
                    ConfigurationDatabase.setRepo(ghrepo);
                }
                if (gitSource == null) {
                    GHRepository defaultRep = github.getRepository("CommonWealthRobotics/BowlerStudioConfiguration");
                    GHRepository forkedRep = defaultRep.fork();
                    ConfigurationDatabase.setRepo(forkedRep);
                }
            } else {
                ConfigurationDatabase.setGitSource(HTTPS_GITHUB_COM_NEURON_ROBOTICS_BOWLER_STUDIO_CONFIGURATION_GIT);
            }
        }
        return gitSource;
    }

    private static void setRepo(GHRepository forkedRep) {
        String myAssets = forkedRep.getGitTransportUrl().replaceAll("git://", "https://");
        ConfigurationDatabase.setGitSource(myAssets);
    }

    public static void setGitSource(String myAssets) {
        database = null;
        gitSource = myAssets;
        ConfigurationDatabase.getDatabase();
    }

    public static String getDbFile() {
        return dbFile;
    }

    public static void setDbFile(String dbFile) {
        ConfigurationDatabase.dbFile = dbFile;
        ConfigurationDatabase.setGitSource(gitSource);
    }

    static {
        database = null;
        TT_mapStringString = new TypeToken<HashMap<String, HashMap<String, Object>>>(){}.getType();
        gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    }
}

