/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.vitamins;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.neuronrobotics.bowlerstudio.scripting.ScriptingEngine;
import com.neuronrobotics.bowlerstudio.vitamins.PurchasingData;
import eu.mihosoft.vrl.v3d.CSG;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.api.errors.TransportException;

public class Purchasing {
    private static String jsonRootDir = "json/";
    private static final Map<String, CSG> fileLastLoaded = new HashMap<String, CSG>();
    private static final Map<String, HashMap<String, HashMap<String, PurchasingData>>> databaseSet = new HashMap<String, HashMap<String, HashMap<String, PurchasingData>>>();
    private static final String defaultgitRpoDatabase = "https://github.com/CommonWealthRobotics/Hardware-Purchasing.git";
    private static String gitRpoDatabase = "https://github.com/CommonWealthRobotics/Hardware-Purchasing.git";
    private static Type TT_mapStringString = new TypeToken<HashMap<String, HashMap<String, PurchasingData>>>(){}.getType();
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static boolean checked;

    public static HashMap<String, PurchasingData> getConfiguration(String type, String id) {
        HashMap<String, HashMap<String, PurchasingData>> database = Purchasing.getDatabase(type);
        if (database.get(id) == null) {
            database.put(id, new HashMap());
        }
        return database.get(id);
    }

    public static void saveDatabase(String type) throws Exception {
        String jsonString = Purchasing.makeJson(type);
        try {
            ScriptingEngine.pushCodeToGit(Purchasing.getGitRpoDatabase(), ScriptingEngine.getFullBranch(Purchasing.getGitRpoDatabase()), Purchasing.getRootFolder() + type + ".json", jsonString, "Pushing changed Database");
        }
        catch (TransportException ex) {
            System.out.println("You need to fork " + Purchasing.getGitRpoDatabase() + " to have permission to save");
            System.out.println("You do not have permission to push to this repo, change the GIT repo to your fork with setGitRpoDatabase(String gitRpoDatabase) ");
            throw ex;
        }
    }

    public static String makeJson(String type) {
        return gson.toJson(Purchasing.getDatabase(type), TT_mapStringString);
    }

    public static void newVitamin(String type, String id) throws Exception {
        HashMap<String, HashMap<String, PurchasingData>> database = Purchasing.getDatabase(type);
        if (database.keySet().size() > 0) {
            String exampleKey = null;
            for (String key : database.keySet()) {
                if (key.contains("meta")) continue;
                exampleKey = key;
            }
            if (exampleKey != null) {
                HashMap<String, PurchasingData> exampleConfiguration = Purchasing.getConfiguration(type, exampleKey);
                HashMap<String, PurchasingData> newConfig = Purchasing.getConfiguration(type, id);
                for (String key : exampleConfiguration.keySet()) {
                    newConfig.put(key, exampleConfiguration.get(key));
                }
            }
        }
        Purchasing.getConfiguration(type, id);
    }

    public static void setParameter(String type, String id, String parameterName, PurchasingData parameter) throws Exception {
        HashMap<String, PurchasingData> config = Purchasing.getConfiguration(type, id);
        config.put(parameterName, parameter);
    }

    public static HashMap<String, HashMap<String, PurchasingData>> getDatabase(String type) {
        if (databaseSet.get(type) == null) {
            FileInputStream inPut = null;
            try {
                File f = ScriptingEngine.fileFromGit(Purchasing.getGitRpoDatabase(), Purchasing.getRootFolder() + type + ".json");
                inPut = FileUtils.openInputStream((File)f);
                String jsonString = IOUtils.toString((InputStream)inPut);
                HashMap database = (HashMap)gson.fromJson(jsonString, TT_mapStringString);
                if (database == null) {
                    throw new RuntimeException("create a new one");
                }
                databaseSet.put(type, database);
            }
            catch (Exception e) {
                databaseSet.put(type, new HashMap());
            }
        }
        return databaseSet.get(type);
    }

    private static String getRootFolder() {
        return Purchasing.getJsonRootDir();
    }

    public static ArrayList<String> listVitaminTypes() {
        ArrayList<String> types = new ArrayList<String>();
        try {
            File[] listOfFiles;
            File folder = ScriptingEngine.fileFromGit(Purchasing.getGitRpoDatabase(), Purchasing.getRootFolder() + "capScrew.json");
            for (File f : listOfFiles = folder.getParentFile().listFiles()) {
                if (f.isDirectory() || !f.getName().endsWith(".json")) continue;
                types.add(f.getName().substring(0, f.getName().indexOf(".json")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return types;
    }

    public static ArrayList<String> listVitaminSizes(String type) {
        ArrayList<String> types = new ArrayList<String>();
        HashMap<String, HashMap<String, PurchasingData>> database = Purchasing.getDatabase(type);
        Set<String> keys = database.keySet();
        for (String s : keys) {
            if (s.contains("meta")) continue;
            types.add(s);
        }
        return types;
    }

    public static ArrayList<String> listVitaminVariants(String type, String size) {
        ArrayList<String> types = new ArrayList<String>();
        HashMap<String, PurchasingData> database = Purchasing.getDatabase(type).get(size);
        Set<String> keys = database.keySet();
        for (String variant : keys) {
            PurchasingData pd = database.get(variant);
            if (variant.endsWith("variant-1")) continue;
            try {
                URL u = new URL(pd.getAPIUrl());
                HttpURLConnection huc = (HttpURLConnection)u.openConnection();
                huc.setRequestMethod("GET");
                huc.connect();
                huc.getResponseCode();
                huc.disconnect();
                u = new URL(pd.getCartUrl());
                huc = (HttpURLConnection)u.openConnection();
                huc.setRequestMethod("GET");
                huc.connect();
                huc.getResponseCode();
                huc.disconnect();
                types.add(variant);
            }
            catch (ConnectException u) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return types;
    }

    public static PurchasingData get(String type, String size, String variant) {
        try {
            return Purchasing.getDatabase(type).get(size).get(variant);
        }
        catch (NullPointerException ex) {
            throw new RuntimeException("Vitamin " + type + " " + size + " " + variant + " does not exist");
        }
    }

    public static String getGitRpoDatabase() throws IOException {
        return gitRpoDatabase;
    }

    public static void setGitRpoDatabase(String gitRpoDatabase) {
        Purchasing.gitRpoDatabase = gitRpoDatabase;
    }

    public static String getJsonRootDir() {
        return jsonRootDir;
    }

    public static void setJsonRootDir(String jsonRootDir) {
        Purchasing.jsonRootDir = jsonRootDir;
    }
}

