/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.creature;

import com.neuronrobotics.bowlerstudio.creature.MobileBaseCadManager;
import com.neuronrobotics.bowlerstudio.scripting.ScriptingEngine;
import com.neuronrobotics.bowlerstudio.util.FileWatchDeviceWrapper;
import com.neuronrobotics.sdk.addons.kinematics.DHParameterKinematics;
import com.neuronrobotics.sdk.addons.kinematics.DhInverseSolver;
import com.neuronrobotics.sdk.addons.kinematics.IDriveEngine;
import com.neuronrobotics.sdk.addons.kinematics.MobileBase;
import com.neuronrobotics.sdk.common.BowlerAbstractDevice;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.api.errors.GitAPIException;

public class MobileBaseLoader {
    private static HashMap<MobileBase, MobileBaseLoader> map = new HashMap();
    private MobileBase base;
    private IDriveEngine defaultDriveEngine;

    private MobileBaseLoader(MobileBase base) {
        this.setBase(base);
        this.setDefaultWalkingEngine(base);
    }

    public void setGitDhEngine(String gitsId, String file, DHParameterKinematics dh) {
        dh.setGitDhEngine(new String[]{gitsId, file});
        this.setDefaultDhParameterKinematics(dh);
    }

    public File setDefaultDhParameterKinematics(DHParameterKinematics device) {
        File code = null;
        try {
            code = ScriptingEngine.fileFromGit(device.getGitDhEngine()[0], device.getGitDhEngine()[1]);
            DhInverseSolver defaultDHSolver = (DhInverseSolver)ScriptingEngine.inlineFileScriptRun(code, null);
            File c = code;
            FileWatchDeviceWrapper.watch((BowlerAbstractDevice)device, code, (fileThatChanged, event) -> {
                try {
                    System.out.println("D-H Solver changed, updating " + device.getScriptingName());
                    DhInverseSolver d = (DhInverseSolver)ScriptingEngine.inlineFileScriptRun(c, null);
                    device.setInverseSolver(d);
                }
                catch (Exception ex) {
                    MobileBaseCadManager.get(this.base).getUi().highlightException(c, ex);
                }
            });
            device.setInverseSolver(defaultDHSolver);
            return code;
        }
        catch (Exception e1) {
            MobileBaseCadManager.get(this.base).getUi().highlightException(code, e1);
            return null;
        }
    }

    public void setDefaultWalkingEngine(MobileBase device) {
        if (this.defaultDriveEngine == null) {
            this.setGitWalkingEngine(device.getGitWalkingEngine()[0], device.getGitWalkingEngine()[1], device);
        }
        for (DHParameterKinematics dh : device.getAllDHChains()) {
            this.setDefaultDhParameterKinematics(dh);
        }
    }

    public void setGitWalkingEngine(String git, String file, MobileBase device) {
        device.setGitWalkingEngine(new String[]{git, file});
        File code = null;
        try {
            code = ScriptingEngine.fileFromGit(git, file);
        }
        catch (IOException | GitAPIException e) {
            MobileBaseCadManager.get(this.base).getUi().highlightException(code, (Exception)e);
        }
        File c = code;
        FileWatchDeviceWrapper.watch((BowlerAbstractDevice)device, code, (fileThatChanged, event) -> {
            try {
                this.defaultDriveEngine = (IDriveEngine)ScriptingEngine.inlineFileScriptRun(c, null);
                device.setWalkingDriveEngine(this.defaultDriveEngine);
            }
            catch (Exception ex) {
                MobileBaseCadManager.get(this.base).getUi().highlightException(c, ex);
            }
        });
        try {
            this.defaultDriveEngine = (IDriveEngine)ScriptingEngine.inlineFileScriptRun(c, null);
            device.setWalkingDriveEngine(this.defaultDriveEngine);
        }
        catch (Exception ex) {
            MobileBaseCadManager.get(this.base).getUi().highlightException(c, ex);
        }
    }

    public static MobileBase initializeScripts(MobileBase base) {
        if (map.get(base) == null) {
            map.put(base, new MobileBaseLoader(base));
        }
        return base;
    }

    public static MobileBase fromGit(String id, String file) throws Exception {
        String xmlContent = ScriptingEngine.codeFromGit(id, file)[0];
        MobileBase mb = new MobileBase(IOUtils.toInputStream((String)xmlContent, (String)"UTF-8"));
        mb.setGitSelfSource(new String[]{id, file});
        return MobileBaseLoader.initializeScripts(mb);
    }

    public static MobileBaseLoader get(MobileBase base) {
        return map.get(MobileBaseLoader.initializeScripts(base));
    }

    public MobileBase getBase() {
        return this.base;
    }

    public void setBase(MobileBase base) {
        this.base = base;
    }
}

